/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiImplUtil");

    private PsiImplUtil() {
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getConstructors must not be null");
        }
        SmartList constructorsList = new SmartList();
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!method.isConstructor()) continue;
            constructorsList.add(method);
        }
        PsiMethod[] psiMethodArray = constructorsList.toArray(new PsiMethod[constructorsList.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls String attributeName) {
        PsiNameValuePair[] attributes;
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findDeclaredAttributeValue must not be null");
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal((String)name, (String)attributeName) && (attributeName != null || !name.equals("value"))) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAttributeValue must not be null");
        }
        PsiAnnotationMemberValue value = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName);
        if (value != null) {
            return value;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ((PsiClass)resolved).getMethods()) {
                if (!(method instanceof PsiAnnotationMethod) || !Comparing.equal((String)method.getName(), (String)attributeName)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiTypeParameter[] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameter[] psiTypeParameterArray;
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not be null");
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        if (typeParameterList != null) {
            psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not return null");
            return psiTypeParameterArray;
        }
        psiTypeParameterArray = PsiTypeParameter.EMPTY_ARRAY;
        if (PsiTypeParameter.EMPTY_ARRAY != null) return psiTypeParameterArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not return null");
    }

    @NotNull
    public static PsiJavaCodeReferenceElement[] namesToPackageReferences(@NotNull PsiManager manager, @NotNull String[] names) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not be null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not be null");
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                refs[i] = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createPackageReferenceElement(name);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (refs == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not return null");
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList) {
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getParameterIndex must not be null");
        }
        if (parameterList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getParameterIndex must not be null");
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameter.equals(parameters[i])) continue;
            return i;
        }
        LOG.error("Parameter " + parameter + " not found among parameters: " + Arrays.asList(parameters) + ". parameterList' parent: " + parameterList.getParent() + "; parameter.getParent()==paramList: " + (parameter.getParent() == parameterList) + "; " + parameterList.getClass());
        return -1;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameterIndex must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameterIndex must not be null");
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.assertTrue(false);
        return -1;
    }

    @NotNull
    public static Object[] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not be null");
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not return null");
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(PsiMethod method, @NotNull PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiTypeParameterList list;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInMethod must not be null");
        }
        ElementClassHint hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)method);
        if ((hint == null || hint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) && (list = method.getTypeParameterList()) != null && !list.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (lastParent instanceof PsiCodeBlock) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                if (processor.execute((PsiElement)parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.hasTypeParameters must not be null");
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        return typeParameterList != null && typeParameterList.getTypeParameters().length != 0;
    }

    @NotNull
    public static PsiType[] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        if (parameterList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.typesByReferenceParameterList must not be null");
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(typeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.typesByReferenceParameterList must not return null");
        }
        return psiTypeArray;
    }

    @NotNull
    public static PsiType[] typesByTypeElements(@NotNull PsiTypeElement[] typeElements) {
        if (typeElements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.typesByTypeElements must not be null");
        }
        PsiType[] types = new PsiType[typeElements.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        if (types == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.typesByTypeElements must not return null");
        }
        return types;
    }

    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getType must not be null");
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)classAccessExpression)) {
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(classClass);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals(operandType)) {
            operandType = PsiType.VOID.equals(operandType) ? JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType((PsiElement)classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor);
    }

    public static PsiAnnotation findAnnotation(@NotNull PsiAnnotationOwner modifierList, @NotNull String qualifiedName) {
        PsiAnnotation[] annotations;
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAnnotation must not be null");
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAnnotation must not be null");
        }
        String shortName = StringUtil.getShortName((String)qualifiedName);
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findDocComment must not be null");
        }
        for (node = element.getFirstChildNode(); node != null && (ElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType()) || node.getElementType() == JavaTokenType.C_STYLE_COMMENT || node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT); node = node.getTreeNext()) {
        }
        if (node != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
            return node;
        }
        return null;
    }

    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type, @NotNull PsiExpression expression) {
        PsiExpression toplevel;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.normalizeWildcardTypeByPosition must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.normalizeWildcardTypeByPosition must not be null");
        }
        for (toplevel = expression; toplevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)toplevel.getParent()).getArrayExpression() == toplevel; toplevel = (PsiExpression)toplevel.getParent()) {
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type, expression, toplevel);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting((PsiExpression)toplevel)) {
            return PsiUtil.captureToplevelWildcards((PsiType)normalized, (PsiElement)expression);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type, PsiExpression expression, PsiExpression toplevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (type instanceof PsiCapturedWildcardType) {
            return PsiImplUtil.doNormalizeWildcardByPosition((PsiType)((PsiCapturedWildcardType)type).getWildcard(), expression, toplevel);
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (PsiUtil.isAccessedForWriting((PsiExpression)toplevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create((PsiWildcardType)wildcardType, (PsiElement)expression);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
        }
        if (type instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type).getComponentType(), expression, toplevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        GlobalSearchScope globalSearchScope;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not be null");
        }
        PsiManagerEx psiManager = (PsiManagerEx)member.getManager();
        GlobalSearchScope maximalUseScope = psiManager.getFileManager().getUseScope((PsiElement)member);
        PsiFile file = member.getContainingFile();
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (aClass instanceof PsiAnonymousClass) {
            PsiElement methodCallExpr = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            globalSearchScope = new LocalSearchScope((PsiElement)(methodCallExpr != null ? methodCallExpr : aClass));
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        if (member.hasModifierProperty("public")) {
            globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        if (member.hasModifierProperty("protected")) {
            globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        if (member.hasModifierProperty("private")) {
            PsiClass topClass = PsiUtil.getTopLevelClass((PsiElement)member);
            globalSearchScope = topClass != null ? new LocalSearchScope((PsiElement)topClass) : new LocalSearchScope((PsiElement)file);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        if (file instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(((PsiJavaFile)file).getPackageName())) != null) {
            GlobalSearchScope scope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
            globalSearchScope = scope = scope.intersectWith((SearchScope)maximalUseScope);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = maximalUseScope;
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setName must not be null");
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name);
        return element.replace((PsiElement)newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.isDeprecatedByAnnotation must not be null");
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.findAnnotation("java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiDocCommentOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.isDeprecatedByDocTag must not be null");
        }
        PsiDocComment docComment = owner.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setDeclaredAttributeValue must not be null");
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setDeclaredAttributeValue must not be null");
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value);
        } else {
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && attributes[0].getName() == null) {
                attributes[0].replace((PsiElement)PsiImplUtil.createNameValuePair(attributes[0].getValue(), "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore((PsiElement)PsiImplUtil.createNameValuePair(value, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value, @NotNull String namePrefix, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        if (namePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        return ((PsiAnnotation)annotationCreator.fun((Object)value.getProject(), (Object)("@A(" + namePrefix + value.getText() + ")"))).getParameterList().getAttributes()[0];
    }
}

