/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValueBase;
import org.jetbrains.annotations.NotNull;

public class PsiCachedValue<T>
extends CachedValueBase<T> {
    private final PsiManager myManager;
    protected long myLastPsiTimeStamp = -1L;

    public PsiCachedValue(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    protected CachedValueBase.Data<T> computeData(T value, Object[] dependencies) {
        CachedValueBase.Data<T> data = super.computeData(value, dependencies);
        this.myLastPsiTimeStamp = this.myManager.getModificationTracker().getModificationCount();
        return data;
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiCachedValue.isUpToDate must not be null");
        }
        return !this.myManager.isDisposed() && super.isUpToDate(data);
    }

    @Override
    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        return (!(dependency instanceof PsiElement) || this.myLastPsiTimeStamp != this.myManager.getModificationTracker().getModificationCount()) && super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element = (PsiElement)dependency;
            if (!element.isValid()) {
                return -1L;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                return -1L;
            }
            return containingFile.getModificationStamp();
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency == PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getJavaStructureModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(Project project) {
        return this.myManager.getProject() == project;
    }
}

