/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnotherLanguageBlockWrapper
extends AbstractXmlBlock {
    private final Block myOriginal;
    private final Indent myIndent;
    private final int myOffset;
    @Nullable
    private final TextRange myRange;

    public AnotherLanguageBlockWrapper(ASTNode node, XmlFormattingPolicy policy, Block original, Indent indent, int offset, @Nullable TextRange range) {
        super(node, original.getWrap(), original.getAlignment(), policy);
        this.myOriginal = original;
        this.myIndent = indent;
        this.myOffset = offset;
        this.myRange = range;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return true;
    }

    @Override
    protected List<Block> buildChildren() {
        if (this.myOffset == 0 && this.myRange == null) {
            return this.myOriginal.getSubBlocks();
        }
        return InjectedLanguageBlockWrapper.buildBlocks(this.myOriginal, this.myOffset, this.myRange);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange;
        TextRange range = super.getTextRange();
        if (this.myOffset == 0) {
            textRange = range;
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper.getTextRange must not return null");
            return textRange;
        }
        textRange = new TextRange(this.myOffset + range.getStartOffset(), this.myOffset + (this.myRange != null ? this.myRange.getLength() : range.getLength()));
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper.getTextRange must not return null");
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof InjectedLanguageBlockWrapper) {
            child1 = ((InjectedLanguageBlockWrapper)child1).myOriginal;
        }
        if (child2 instanceof InjectedLanguageBlockWrapper) {
            child2 = ((InjectedLanguageBlockWrapper)child2).myOriginal;
        }
        return this.myOriginal.getSpacing(child1, child2);
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper.getChildAttributes must not return null");
        }
        return childAttributes;
    }
}

