/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;

public class JavaBlockUtil {
    public static boolean mayShiftIndentInside(ASTNode leaf) {
        return JavaBlockUtil.isComment(leaf) && !JavaBlockUtil.checkJspTexts(leaf) || leaf.getElementType() == TokenType.WHITE_SPACE || leaf.getElementType() == XmlElementType.XML_DATA_CHARACTERS || leaf.getElementType() == JspElementType.JAVA_CODE || leaf.getElementType() == JspElementType.JSP_SCRIPTLET || leaf.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean checkJspTexts(ASTNode leaf) {
        for (ASTNode child = leaf.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }
}

