/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBasedFormattingModel
implements FormattingModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.PsiBasedFormattingModel");
    private final ASTNode myASTNode;
    private final FormattingDocumentModelImpl myDocumentModel;
    @NotNull
    private final Block myRootBlock;
    protected boolean myCanModifyAllWhiteSpaces;

    public PsiBasedFormattingModel(PsiFile file, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/formatter/PsiBasedFormattingModel.<init> must not be null");
        }
        this.myCanModifyAllWhiteSpaces = false;
        this.myASTNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file);
        this.myDocumentModel = documentModel;
        this.myRootBlock = rootBlock;
    }

    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        String wsReplaced = this.replaceWithPSI(textRange, whiteSpace);
        if (wsReplaced != null) {
            return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + wsReplaced.length());
        }
        return textRange;
    }

    public TextRange shiftIndentInsideRange(TextRange textRange, int shift) {
        return textRange;
    }

    public void commitChanges() {
    }

    @Nullable
    private String replaceWithPSI(TextRange textRange, String whiteSpace) {
        int offset = textRange.getEndOffset();
        ASTNode leafElement = this.findElementAt(offset);
        if (leafElement != null) {
            if (leafElement.getPsi() instanceof PsiFile) {
                return null;
            }
            if (!leafElement.getPsi().isValid()) {
                String message = "Invalid element found in '\n" + this.myASTNode.getText() + "\n' at " + offset + "(" + this.myASTNode.getText().substring(offset, Math.min(offset + 10, this.myASTNode.getTextLength()));
                LOG.error(message);
            }
            return this.replaceWithPsiInLeaf(textRange, whiteSpace, leafElement);
        }
        if (textRange.getEndOffset() == this.myASTNode.getTextLength()) {
            FormatterUtil.replaceLastWhiteSpace(this.myASTNode, whiteSpace, textRange);
            return whiteSpace;
        }
        return null;
    }

    @Nullable
    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces && leafElement.getElementType() == TokenType.WHITE_SPACE) {
            return null;
        }
        FormatterUtil.replaceWhiteSpace(whiteSpace, leafElement, TokenType.WHITE_SPACE, textRange);
        return whiteSpace;
    }

    @Nullable
    protected ASTNode findElementAt(int offset) {
        PsiElement psiElement;
        PsiFile containingFile = this.myASTNode.getPsi().getContainingFile();
        Project project = containingFile.getProject();
        assert (!PsiDocumentManager.getInstance((Project)project).isUncommited(this.myDocumentModel.getDocument()));
        PsiElement psiElement2 = psiElement = project.isDefault() ? null : InjectedLanguageUtil.findInjectedElementNoCommitWithOffset(containingFile, offset);
        if (psiElement == null) {
            psiElement = containingFile.findElementAt(offset);
        }
        if (psiElement == null) {
            return null;
        }
        return psiElement.getNode();
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        FormattingDocumentModelImpl formattingDocumentModelImpl = this.myDocumentModel;
        if (formattingDocumentModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/PsiBasedFormattingModel.getDocumentModel must not return null");
        }
        return formattingDocumentModelImpl;
    }

    @NotNull
    public Block getRootBlock() {
        Block block = this.myRootBlock;
        if (block == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/PsiBasedFormattingModel.getRootBlock must not return null");
        }
        return block;
    }

    public void canModifyAllWhiteSpaces() {
        this.myCanModifyAllWhiteSpaces = true;
    }
}

