/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassLiteralLookupElement
extends LookupElement
implements TypedLookupItem {
    @NonNls
    private static final String DOT_CLASS = ".class";
    private final PsiExpression myExpr;
    private final String myPresentableText;
    private final String myCanonicalText;

    public ClassLiteralLookupElement(PsiClassType type, PsiElement context) {
        this.myCanonicalText = type.getCanonicalText();
        this.myPresentableText = type.getPresentableText();
        this.myExpr = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createExpressionFromText(this.myCanonicalText + DOT_CLASS, context);
    }

    @NotNull
    public String getLookupString() {
        String string = this.myPresentableText + DOT_CLASS;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/filters/getters/ClassLiteralLookupElement.getLookupString must not return null");
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setIcon(this.myExpr.getIcon(0));
        PsiType type = this.myExpr.getType();
        if (type != null) {
            presentation.setTypeText(type.getPresentableText());
        }
    }

    @NotNull
    public Object getObject() {
        PsiExpression psiExpression = this.myExpr;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/filters/getters/ClassLiteralLookupElement.getObject must not return null");
        }
        return psiExpression;
    }

    @Override
    public PsiType getType() {
        return this.myExpr.getType();
    }

    public void handleInsert(InsertionContext context) {
        Document document = context.getEditor().getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)(this.myCanonicalText + DOT_CLASS));
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)context.getFile(), context.getStartOffset(), context.getTailOffset());
    }
}

