/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolderViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private DummyHolder myHolder;
    private final PsiManager myManager;
    private final long myModificationStamp;
    private final LightVirtualFile myLightVirtualFile = new LightVirtualFile("DummyHolder");

    public DummyHolderViewProvider(PsiManager manager) {
        this.myManager = manager;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getManager must not return null");
        }
        return psiManager;
    }

    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    @NotNull
    public CharSequence getContents() {
        String string = this.myHolder != null ? this.myHolder.getNode().getText() : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getContents must not return null");
        }
        return string;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = this.myLightVirtualFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getVirtualFile must not return null");
        }
        return lightVirtualFile;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myHolder.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getBaseLanguage must not return null");
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getLanguages must not return null");
        }
        return set;
    }

    public PsiFile getPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.getPsi must not be null");
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target == this.getBaseLanguage() ? this.myHolder : null;
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = Collections.singletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getAllFiles must not return null");
        }
        return list;
    }

    public void beforeContentsSynchronized() {
    }

    public void contentsSynchronized() {
    }

    public boolean isEventSystemEnabled() {
        return false;
    }

    public boolean isPhysical() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public boolean supportsIncrementalReparse(Language rootLanguage) {
        return true;
    }

    public void rootChanged(PsiFile psiFile) {
    }

    public void setDummyHolder(DummyHolder dummyHolder) {
        this.myHolder = dummyHolder;
    }

    public FileViewProvider clone() {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    @Nullable
    public PsiElement findElementAt(int offset, Language language) {
        return language == this.getBaseLanguage() ? this.findElementAt(offset) : null;
    }

    public PsiElement findElementAt(int offset, Class<? extends Language> lang) {
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offsetInElement, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.findReferenceAt must not be null");
        }
        return language == this.getBaseLanguage() ? this.findReferenceAt(offsetInElement) : null;
    }

    public boolean isLockedByPsiOperations() {
        return false;
    }

    @NotNull
    public FileViewProvider createCopy(LightVirtualFile copy) {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    public PsiElement findElementAt(int offset) {
        LeafElement element = ((PsiFileImpl)this.getPsi(this.getBaseLanguage())).calcTreeElement().findLeafElementAt(offset);
        return element != null ? element.getPsi() : null;
    }
}

