/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.LightPsiFileImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeLanguageFileViewProvider
extends SingleRootFileViewProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.CompositeLanguageFileViewProvider");
    private final ConcurrentHashMap<Language, PsiFile> myRoots;
    private Set<Language> myRelevantLanguages;
    private final Set<PsiFile> myRootsInUpdate;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set;
        if (this.myRelevantLanguages != null) {
            set = this.myRelevantLanguages;
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/psi/CompositeLanguageFileViewProvider.getLanguages must not return null");
            return set;
        }
        HashSet<Language> relevantLanguages = new HashSet<Language>();
        Language baseLanguage = this.getBaseLanguage();
        relevantLanguages.add(baseLanguage);
        relevantLanguages.addAll(this.myRoots.keySet());
        set = this.myRelevantLanguages = new LinkedHashSet<Language>(relevantLanguages);
        if (this.myRelevantLanguages != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/psi/CompositeLanguageFileViewProvider.getLanguages must not return null");
    }

    @Override
    public void contentsSynchronized() {
        super.contentsSynchronized();
        this.myRelevantLanguages = null;
    }

    public CompositeLanguageFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
        this.myRoots = new ConcurrentHashMap(1, 0.75f, 1);
        this.myRootsInUpdate = new HashSet<PsiFile>(4);
    }

    protected CompositeLanguageFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/CompositeLanguageFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/CompositeLanguageFileViewProvider.<init> must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/CompositeLanguageFileViewProvider.<init> must not be null");
        }
        super(manager, virtualFile, physical, language);
        this.myRoots = new ConcurrentHashMap(1, 0.75f, 1);
        this.myRootsInUpdate = new HashSet<PsiFile>(4);
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(LightVirtualFile copy) {
        CompositeLanguageFileViewProvider viewProvider = this.cloneInner((VirtualFile)copy);
        PsiFileImpl psiFile = (PsiFileImpl)viewProvider.getPsi(this.getBaseLanguage());
        assert (psiFile != null);
        psiFile.setOriginalFile(this.getPsi(this.getBaseLanguage()));
        FileElement treeClone = (FileElement)psiFile.calcTreeElement().clone();
        psiFile.setTreeElementPointer(treeClone);
        treeClone.setPsi((PsiElement)psiFile);
        for (Map.Entry entry : this.myRoots.entrySet()) {
            PsiFile root = (PsiFile)entry.getValue();
            if (root == psiFile || root == null || root.getLanguage() == this.getBaseLanguage()) continue;
            if (root instanceof LightPsiFileImpl) {
                LightPsiFileImpl lightFile = (LightPsiFileImpl)root;
                LightPsiFileImpl clone = lightFile.copyLight(viewProvider);
                clone.setOriginalFile(root);
                viewProvider.myRoots.put(entry.getKey(), (Object)clone);
                continue;
            }
            LOG.error("Only light files supported for language extensions, passed: " + root);
        }
        CompositeLanguageFileViewProvider compositeLanguageFileViewProvider = viewProvider;
        if (compositeLanguageFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/CompositeLanguageFileViewProvider.createCopy must not return null");
        }
        return compositeLanguageFileViewProvider;
    }

    protected CompositeLanguageFileViewProvider cloneInner(VirtualFile copy) {
        return new CompositeLanguageFileViewProvider(this.getManager(), copy, false);
    }

    @Override
    @Nullable
    protected PsiFile getPsiInner(Language target) {
        PsiFile file = super.getPsiInner(target);
        if (file != null) {
            return file;
        }
        file = (PsiFile)this.myRoots.get((Object)target);
        if (file == null) {
            file = this.createFile(target);
            if (file == null) {
                return null;
            }
            file = (PsiFile)this.myRoots.cacheOrGet((Object)target, (Object)file);
        }
        return file;
    }

    @Override
    public PsiFile getCachedPsi(Language target) {
        if (target == this.getBaseLanguage()) {
            return super.getCachedPsi(target);
        }
        return (PsiFile)this.myRoots.get((Object)target);
    }

    public void checkAllTreesEqual() {
        String psiText = this.getPsi(this.getBaseLanguage()).getText();
        for (Map.Entry entry : this.myRoots.entrySet()) {
            PsiFile psiFile = (PsiFile)entry.getValue();
            LOG.assertTrue(psiFile.getTextLength() == psiText.length(), (Object)(((Language)entry.getKey()).getID() + " tree text differs from base!"));
            LOG.assertTrue(psiFile.getText().equals(psiText), (Object)(((Language)entry.getKey()).getID() + " tree text differs from base!"));
        }
    }

    @Override
    public FileElement[] getKnownTreeRoots() {
        ArrayList<FileElement> knownRoots = new ArrayList<FileElement>();
        knownRoots.addAll(Arrays.asList(super.getKnownTreeRoots()));
        for (PsiFile psiFile : this.myRoots.values()) {
            FileElement fileElement;
            if (psiFile == null || !(psiFile instanceof PsiFileImpl) || (fileElement = ((PsiFileImpl)psiFile).getTreeElement()) == null) continue;
            knownRoots.add(fileElement);
        }
        return knownRoots.toArray(new FileElement[knownRoots.size()]);
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, Class<? extends Language> lang) {
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionCache.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = CompositeLanguageFileViewProvider.findElementAt((PsiElement)(psiRoot = this.getPsi(language)), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt((PsiElement)psiRoot, offset);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset()))) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    private void checkConsistensy(PsiFile oldFile) {
        ASTNode oldNode = oldFile.getNode();
        if (oldNode.getTextLength() != this.getContents().length() || !oldNode.getText().equals(((Object)this.getContents()).toString())) {
            String message = "Check consistency failed for: " + oldFile;
            message = message + "\n     oldFile.getNode().getTextLength() = " + oldNode.getTextLength();
            message = message + "\n     getContents().length() = " + this.getContents().length();
            message = message + "\n     language = " + oldFile.getLanguage();
            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                message = message + "\n     oldFileText:\n" + oldNode.getText();
                message = message + "\n     contentsText:\n" + ((Object)this.getContents()).toString();
                message = message + "\n     jspText:\n" + this.getPsi(this.getBaseLanguage()).getNode().getText();
            }
            LOG.error(message);
            assert (false);
        }
    }

    public LanguageFilter[] getLanguageExtensions() {
        return new LanguageFilter[0];
    }

    protected void removeFile(Language lang) {
        this.myRoots.remove((Object)lang);
    }

    @Override
    @Nullable
    protected PsiFile createFile(Language lang) {
        PsiFile psiFile = super.createFile(lang);
        if (psiFile != null) {
            return psiFile;
        }
        if (this.isIgnored()) {
            return null;
        }
        if (this.isRelevantLanguage(lang)) {
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            assert (parserDefinition != null);
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    protected boolean isRelevantLanguage(Language lang) {
        return this.getLanguages().contains(lang);
    }

    @Override
    public void rootChanged(PsiFile psiFile) {
        if (this.myRootsInUpdate.contains(psiFile)) {
            return;
        }
        if (psiFile.getLanguage() == this.getBaseLanguage()) {
            super.rootChanged(psiFile);
        } else if (!this.myRootsInUpdate.contains(this.getPsi(this.getBaseLanguage()))) {
            LOG.error("Changing PSI for aux trees is not supported");
        }
    }

    public Set<PsiFile> getRootsInUpdate() {
        return this.myRootsInUpdate;
    }
}

