/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

public class ImportChooserStep
extends ProjectImportWizardStep {
    private static final String PREFFERED = "create.project.preffered.importer";
    private final StepSequence mySequence;
    private final JList myList;
    private final JPanel myPanel;

    public ImportChooserStep(ProjectImportProvider[] providers, StepSequence sequence, WizardContext context) {
        super(context);
        this.mySequence = sequence;
        this.myPanel = new JPanel(new BorderLayout());
        DefaultListModel<ProjectImportProvider> model = new DefaultListModel<ProjectImportProvider>();
        this.myList = new JList(model);
        for (ProjectImportProvider provider : ImportChooserStep.sorted(providers)) {
            model.addElement(provider);
        }
        this.myList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((ProjectImportProvider)value).getName());
                this.setIcon(((ProjectImportProvider)value).getIcon());
                return rendererComponent;
            }
        });
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myList), "Center");
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectImportProvider provider = (ProjectImportProvider)ImportChooserStep.this.myList.getSelectedValue();
                if (provider != null) {
                    ImportChooserStep.this.mySequence.setType(provider.getId());
                }
            }
        });
        String id = PropertiesComponent.getInstance().getValue(PREFFERED);
        if (id == null) {
            this.myList.setSelectedIndex(0);
        } else {
            for (ProjectImportProvider provider : providers) {
                if (!Comparing.strEqual((String)provider.getId(), (String)id)) continue;
                this.myList.setSelectedValue(provider, true);
                break;
            }
        }
    }

    private static List<ProjectImportProvider> sorted(ProjectImportProvider[] providers) {
        ArrayList<ProjectImportProvider> result = new ArrayList<ProjectImportProvider>();
        Collections.addAll(result, providers);
        Collections.sort(result, new Comparator<ProjectImportProvider>(){

            @Override
            public int compare(ProjectImportProvider l, ProjectImportProvider r) {
                return l.getName().compareToIgnoreCase(r.getName());
            }
        });
        return result;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public void updateDataModel() {
        Object selectedValue = this.myList.getSelectedValue();
        if (selectedValue instanceof ProjectImportProvider) {
            this.mySequence.setType(((ProjectImportProvider)selectedValue).getId());
            ProjectImportBuilder builder = ((ProjectImportProvider)selectedValue).getBuilder();
            this.getWizardContext().setProjectBuilder((ProjectBuilder)builder);
            builder.setUpdate(this.getWizardContext().getProject() != null);
            PropertiesComponent.getInstance().setValue(PREFFERED, ((ProjectImportProvider)selectedValue).getId());
        }
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import";
    }
}

