/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Icons;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DeleteScopeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + DeleteScopeAction.class.getName()));
    private final Tree myTree;

    public DeleteScopeAction(Tree tree) {
        super("Delete Scope", "Delete Scope", Icons.DELETE_ICON);
        this.myTree = tree;
        this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)this.myTree);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.getSelectedProfile() == null) {
            return;
        }
        InspectionConfigTreeNode[] nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        if (nodes.length > 0) {
            for (InspectionConfigTreeNode node : nodes) {
                if (node.getScopeName() != null && !node.isByDefault()) continue;
                return;
            }
            presentation.setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionConfigTreeNode[] nodes;
        InspectionConfigTreeNode parent = null;
        for (InspectionConfigTreeNode node : nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null)) {
            Descriptor descriptor = node.getDesriptor();
            LOG.assertTrue(descriptor != null);
            parent = (InspectionConfigTreeNode)((Object)node.getParent());
            HighlightDisplayKey key = descriptor.getKey();
            if (parent.getChildCount() <= 2) {
                this.getSelectedProfile().removeAllScopes(key.toString());
                parent.removeAllChildren();
                parent.setInspectionNode(true);
                parent.setByDefault(true);
            } else {
                this.getSelectedProfile().removeScope(key.toString(), parent.getIndex((TreeNode)((Object)node)));
                node.removeFromParent();
            }
            ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)((Object)parent));
        }
        if (parent != null) {
            this.myTree.setSelectionPath(new TreePath(parent.getPath()));
        }
        this.myTree.revalidate();
    }

    protected abstract InspectionProfileImpl getSelectedProfile();
}

