/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AddScopeAction
extends AnAction {
    private final Tree myTree;
    private static final Logger LOG = Logger.getInstance((String)("#" + AddScopeAction.class.getName()));

    public AddScopeAction(Tree tree) {
        super("Add Scope", "Add Scope", Icons.ADD_ICON);
        this.myTree = tree;
        this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)this.myTree);
    }

    public void update(AnActionEvent e) {
        InspectionConfigTreeNode node;
        Descriptor descriptor;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.getSelectedProfile() == null) {
            return;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        InspectionConfigTreeNode[] nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        if (nodes.length > 0 && (descriptor = (node = nodes[0]).getDesriptor()) != null && node.getScopeName() == null && !this.getAvailableScopes(descriptor, project).isEmpty()) {
            presentation.setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionConfigTreeNode[] nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        InspectionConfigTreeNode node = nodes[0];
        Descriptor descriptor = node.getDesriptor();
        LOG.assertTrue(descriptor != null);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        InspectionProfileEntry tool = descriptor.getTool();
        List<String> availableScopes = this.getAvailableScopes(descriptor, project);
        int idx = Messages.showChooseDialog((Component)this.myTree, (String)"Scope:", (String)"Choose Scope", (String[])ArrayUtil.toStringArray(availableScopes), (String)availableScopes.get(0), (Icon)Messages.getQuestionIcon());
        if (idx == -1) {
            return;
        }
        NamedScope chosenScope = NamedScopesHolder.getScope((Project)project, (String)availableScopes.get(idx));
        ScopeToolState scopeToolState = this.getSelectedProfile().addScope(tool, chosenScope, this.getSelectedProfile().getErrorLevel(descriptor.getKey(), chosenScope), this.getSelectedProfile().isToolEnabled(descriptor.getKey()));
        Descriptor addedDescriptor = new Descriptor(scopeToolState, this.getSelectedProfile());
        if (node.getChildCount() == 0) {
            node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(descriptor, scopeToolState, true, true, false)));
        }
        node.insert((MutableTreeNode)((Object)new InspectionConfigTreeNode(addedDescriptor, scopeToolState, false, true, false)), 0);
        node.setInspectionNode(false);
        node.isProperSetting = this.getSelectedProfile().isProperSetting(HighlightDisplayKey.find((String)tool.getShortName()));
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)((Object)node));
        this.myTree.expandPath(new TreePath(node.getPath()));
        this.myTree.revalidate();
    }

    private List<String> getAvailableScopes(Descriptor descriptor, Project project) {
        ArrayList scopes = new ArrayList();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            Collections.addAll(scopes, holder.getScopes());
        }
        scopes.remove(DefaultScopesProvider.getAllScope());
        HashSet<NamedScope> used = new HashSet<NamedScope>();
        List<ScopeToolState> nonDefaultTools = this.getSelectedProfile().getNonDefaultTools(descriptor.getKey().toString());
        if (nonDefaultTools != null) {
            for (ScopeToolState state : nonDefaultTools) {
                used.add(state.getScope());
            }
        }
        scopes.removeAll(used);
        ArrayList<String> availableScopes = new ArrayList<String>();
        for (NamedScope scope : scopes) {
            availableScopes.add(scope.getName());
        }
        return availableScopes;
    }

    protected abstract InspectionProfileImpl getSelectedProfile();
}

