/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlTagChildAdd;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;

public class XmlTagChildAddImpl
implements XmlTagChildAdd {
    private final XmlTag myTag;
    private final XmlTagChild myChild;

    public XmlTagChildAddImpl(XmlTag context, XmlTagChild treeElement) {
        this.myTag = context;
        this.myChild = treeElement;
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public XmlTagChild getChild() {
        return this.myChild;
    }

    public static PomModelEvent createXmlTagChildAdd(PomModel source, XmlTag context, XmlTagChild treeElement) {
        PomModelEvent event = new PomModelEvent(source);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)context, XmlFile.class));
        xmlAspectChangeSet.add((XmlChange)new XmlTagChildAddImpl(context, treeElement));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "child added to " + this.getTag().getName() + " child: " + this.myChild.toString();
    }

    public void accept(XmlChangeVisitor visitor) {
        visitor.visitXmlTagChildAdd((XmlTagChildAdd)this);
    }
}

