/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectConfigurator
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(Project project, final @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/platform/PlatformProjectConfigurator.configureProject must not be null");
        }
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length == 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    String moduleName = baseDir.getName().replace(":", "");
                    String imlName = baseDir.getPath() + "/.idea/" + moduleName + ".iml";
                    Module module = moduleManager.newModule(imlName, ModuleTypeManager.getInstance().getDefaultModuleType());
                    ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    rootModel.addContentEntry(baseDir);
                    rootModel.inheritSdk();
                    rootModel.commit();
                }
            });
        }
    }
}

