/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class NewDirectoryProjectDialog
extends DialogWrapper {
    private JTextField myProjectNameTextField;
    private TextFieldWithBrowseButton myLocationField;
    private JPanel myRootPane;
    private JComboBox myProjectTypeComboBox;
    private JPanel myProjectTypePanel;
    private String myBaseDir;
    private static final Object EMPTY_PROJECT_GENERATOR = new Object();

    protected NewDirectoryProjectDialog(Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle("Create New Project");
        this.init();
        this.myBaseDir = NewDirectoryProjectDialog.getBaseDir();
        File projectName = FileUtil.findSequentNonexistentFile((File)new File(this.myBaseDir), (String)"untitled", (String)"");
        this.myLocationField.setText(projectName.toString());
        this.myProjectNameTextField.setText(projectName.getName());
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>("Select Location for Project Directory", "", (ComponentWithBrowseButton)this.myLocationField, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChoosen(VirtualFile chosenFile) {
                super.onFileChoosen(chosenFile);
                NewDirectoryProjectDialog.this.myBaseDir = chosenFile.getPath();
                NewDirectoryProjectDialog.this.myLocationField.setText(new File(chosenFile.getPath(), NewDirectoryProjectDialog.this.myProjectNameTextField.getText()).toString());
            }
        };
        this.myLocationField.addActionListener((ActionListener)listener);
        this.myProjectNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NewDirectoryProjectDialog.this.myLocationField.setText(new File(NewDirectoryProjectDialog.this.myBaseDir, NewDirectoryProjectDialog.this.myProjectNameTextField.getText()).getPath());
            }
        });
        this.myProjectNameTextField.selectAll();
        DirectoryProjectGenerator[] generators = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
        if (generators.length == 0) {
            this.myProjectTypePanel.setVisible(false);
        } else {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
            model.addElement(EMPTY_PROJECT_GENERATOR);
            for (DirectoryProjectGenerator generator : generators) {
                model.addElement(generator);
            }
            this.myProjectTypeComboBox.setModel(model);
            this.myProjectTypeComboBox.setRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value == null) {
                        return;
                    }
                    if (value == EMPTY_PROJECT_GENERATOR) {
                        this.append("Empty project", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        DirectoryProjectGenerator generator = (DirectoryProjectGenerator)value;
                        this.append(generator.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }
    }

    public static String getBaseDir() {
        String lastProjectLocation = GeneralSettings.getInstance().getLastProjectLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        return userHome.replace('/', File.separatorChar) + File.separator + ApplicationNamesInfo.getInstance().getLowercaseProductName() + "Projects";
    }

    protected JComponent createCenterPanel() {
        return this.myRootPane;
    }

    public String getNewProjectLocation() {
        return this.myLocationField.getText();
    }

    public String getNewProjectName() {
        return this.myProjectNameTextField.getText();
    }

    @Nullable
    public DirectoryProjectGenerator getProjectGenerator() {
        Object selItem = this.myProjectTypeComboBox.getSelectedItem();
        if (selItem == EMPTY_PROJECT_GENERATOR) {
            return null;
        }
        return (DirectoryProjectGenerator)selItem;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectNameTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel2;
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Project name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Location:");
        jLabel2.setDisplayedMnemonic('L');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProjectNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        this.myProjectTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Project type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectTypeComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

