/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactChooser
extends ElementsChooser<ArtifactPointer> {
    private static final Comparator<ArtifactPointer> ARTIFACT_COMPARATOR = new Comparator<ArtifactPointer>(){

        @Override
        public int compare(ArtifactPointer o1, ArtifactPointer o2) {
            return o1.getArtifactName().compareToIgnoreCase(o2.getArtifactName());
        }
    };
    private static final ElementsChooser.ElementProperties INVALID_ARTIFACT_PROPERTIES = new ElementsChooser.ElementProperties(){

        @Override
        public Icon getIcon() {
            return PlainArtifactType.ARTIFACT_ICON;
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }
    };

    public ArtifactChooser(List<ArtifactPointer> pointers) {
        super(pointers, false);
        for (ArtifactPointer pointer : pointers) {
            if (pointer.getArtifact() != null) continue;
            this.setElementProperties(pointer, INVALID_ARTIFACT_PROPERTIES);
        }
        this.sort(ARTIFACT_COMPARATOR);
    }

    @Override
    protected String getItemText(@NotNull ArtifactPointer value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/run/ArtifactChooser.getItemText must not be null");
        }
        return value.getArtifactName();
    }

    @Override
    protected Icon getItemIcon(ArtifactPointer value) {
        Artifact artifact = value.getArtifact();
        return artifact != null ? artifact.getArtifactType().getIcon() : null;
    }
}

