/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ModuleOutputElementType
extends PackagingElementType<ModuleOutputPackagingElement> {
    public static final ModuleOutputElementType MODULE_OUTPUT_ELEMENT_TYPE = new ModuleOutputElementType();

    ModuleOutputElementType() {
        super("module-output", CompilerBundle.message((String)"element.type.name.module.output", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return IconLoader.getIcon((String)"/nodes/ModuleOpen.png");
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.canCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.canCreate must not be null");
        }
        return context.getModulesProvider().getModules().length > 0;
    }

    @NotNull
    public List<? extends ModuleOutputPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.chooseAndCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.chooseAndCreate must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.chooseAndCreate must not be null");
        }
        List<Module> modules = ModuleOutputElementType.chooseModules(context);
        ArrayList<ModuleOutputPackagingElement> elements = new ArrayList<ModuleOutputPackagingElement>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)context.getProject());
        for (Module module : modules) {
            elements.add(new ModuleOutputPackagingElement(context.getProject(), pointerManager.create(module)));
        }
        ArrayList<ModuleOutputPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ModuleOutputElementType.chooseAndCreate must not return null");
        }
        return arrayList;
    }

    public static List<Module> chooseModules(ArtifactEditorContext context) {
        return context.chooseModules(Arrays.asList(context.getModulesProvider().getModules()), ProjectBundle.message((String)"dialog.title.packaging.choose.module", (Object[])new Object[0]));
    }

    @NotNull
    public ModuleOutputPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputElementType.createEmpty must not be null");
        }
        ModuleOutputPackagingElement moduleOutputPackagingElement = new ModuleOutputPackagingElement(project);
        if (moduleOutputPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ModuleOutputElementType.createEmpty must not return null");
        }
        return moduleOutputPackagingElement;
    }
}

