/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedPackagingElementType<E extends PackagingElement<?>, F extends Facet>
extends PackagingElementType<E> {
    private final FacetTypeId<F> myFacetType;

    protected FacetBasedPackagingElementType(@NotNull @NonNls String id, @NotNull String presentableName, FacetTypeId<F> facetType) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.<init> must not be null");
        }
        if (presentableName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.<init> must not be null");
        }
        super(id, presentableName);
        this.myFacetType = facetType;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.canCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.canCreate must not be null");
        }
        return !this.getFacets(context).isEmpty();
    }

    public Icon getCreateElementIcon() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetType).getIcon();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<? extends E> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List list;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.chooseAndCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.chooseAndCreate must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.chooseAndCreate must not be null");
        }
        List<F> facets = this.getFacets(context);
        ChooseFacetsDialog dialog = new ChooseFacetsDialog(context.getProject(), facets, this.getDialogTitle(), this.getDialogDescription());
        dialog.show();
        if (dialog.isOK()) {
            ArrayList elements = new ArrayList();
            for (Facet facet : dialog.getChosenElements()) {
                elements.add(this.createElement(context.getProject(), facet));
            }
            list = elements;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.chooseAndCreate must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/FacetBasedPackagingElementType.chooseAndCreate must not return null");
    }

    private List<F> getFacets(ArtifactEditorContext context) {
        Module[] modules = context.getModulesProvider().getModules();
        ArrayList facets = new ArrayList();
        for (Module module : modules) {
            facets.addAll(context.getFacetsProvider().getFacetsByType(module, this.myFacetType));
        }
        return facets;
    }

    protected abstract E createElement(Project var1, F var2);

    protected abstract String getDialogTitle();

    protected abstract String getDialogDescription();

    protected abstract String getItemText(F var1);

    @Nullable
    protected Icon getIcon(F item) {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetType).getIcon();
    }

    private class ChooseFacetsDialog
    extends ChooseElementsDialog<F> {
        private ChooseFacetsDialog(Project project, List<? extends F> items, String title, String description) {
            super(project, items, title, description, true);
        }

        @Override
        protected String getItemText(F item) {
            return FacetBasedPackagingElementType.this.getItemText(item);
        }

        @Override
        protected Icon getItemIcon(F item) {
            return FacetBasedPackagingElementType.this.getIcon(item);
        }
    }
}

