/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.DirectoryCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<DirectoryCopyPackagingElement> {
    public DirectoryCopyPackagingElement() {
        super(PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE);
    }

    public DirectoryCopyPackagingElement(String directoryPath) {
        this();
        this.myFilePath = directoryPath;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.createPresentation must not be null");
        }
        return new DirectoryCopyPresentation(this.myFilePath);
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (creator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (generationContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeAntInstructions must not be null");
        }
        String path = generationContext.getSubstitutedPath(this.myFilePath);
        return Collections.singletonList(creator.createDirectoryContentCopyInstruction(path));
    }

    public void computeIncrementalCompilerInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, @NotNull ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        VirtualFile file = this.findFile();
        if (file != null && file.isValid() && file.isDirectory()) {
            creator.addDirectoryCopyInstructions(file, null);
        }
    }

    public DirectoryCopyPackagingElement getState() {
        return this;
    }

    public void loadState(DirectoryCopyPackagingElement state) {
        this.myFilePath = state.getFilePath();
    }

    public String toString() {
        return "dir:" + this.myFilePath;
    }
}

