/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import org.jetbrains.annotations.Nullable;

public class ShowProcessWindowAction
extends ToggleAction
implements DumbAware {
    public ShowProcessWindowAction() {
        super(ActionsBundle.message((String)"action.ShowProcessWindow.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.ShowProcessWindow.description", (Object[])new Object[0]), null);
    }

    public boolean isSelected(AnActionEvent e) {
        IdeFrameImpl frame = this.getFrame();
        if (frame == null) {
            return false;
        }
        return frame.getStatusBar().isProcessWindowOpen();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.getFrame() != null);
    }

    @Nullable
    private IdeFrameImpl getFrame() {
        for (Container window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow(); window != null; window = window.getParent()) {
            if (!(window instanceof IdeFrameImpl)) continue;
            return (IdeFrameImpl)window;
        }
        return null;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        IdeFrameImpl frame = this.getFrame();
        if (frame == null) {
            return;
        }
        frame.getStatusBar().setProcessWindowOpen(state);
    }
}

