/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class PositionPanel
extends TextPanel
implements StatusBarPatch {
    public PositionPanel(StatusBar statusBar) {
        super(false, "#############");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    final Project project = PositionPanel.this.getProject();
                    if (project == null) {
                        return;
                    }
                    final Editor editor = PositionPanel.getEditor(project);
                    if (editor == null) {
                        return;
                    }
                    CommandProcessor processor = CommandProcessor.getInstance();
                    processor.executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            GotoLineNumberDialog dialog = new GotoLineNumberDialog(project, editor);
                            dialog.show();
                            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                        }
                    }, UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
                }
            }
        });
        StatusBarTooltipper.install(this, statusBar);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(final Editor editor, JComponent componentSelected) {
        if (editor != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!editor.isDisposed()) {
                        StringBuilder message = new StringBuilder();
                        SelectionModel selectionModel = editor.getSelectionModel();
                        if (selectionModel.hasBlockSelection()) {
                            LogicalPosition start = selectionModel.getBlockStart();
                            LogicalPosition end = selectionModel.getBlockEnd();
                            PositionPanel.appendLogicalPosition(start, message);
                            message.append("-");
                            PositionPanel.appendLogicalPosition(new LogicalPosition(Math.abs(end.line - start.line), Math.abs(end.column - start.column) - 1), message);
                        } else {
                            LogicalPosition caret = editor.getCaretModel().getLogicalPosition();
                            PositionPanel.appendLogicalPosition(caret, message);
                            if (selectionModel.hasSelection()) {
                                int len = Math.abs(selectionModel.getSelectionStart() - selectionModel.getSelectionEnd());
                                message.append("/");
                                message.append(len);
                            }
                        }
                        PositionPanel.this.setText(message.toString());
                    }
                }
            });
            return UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
        }
        this.clear();
        return null;
    }

    private static void appendLogicalPosition(LogicalPosition caret, StringBuilder message) {
        message.append(caret.line + 1);
        message.append(":");
        message.append(caret.column + 1);
    }

    @Override
    public void clear() {
        this.setText("");
    }

    private static Editor getEditor(Project project) {
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    private Project getProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
    }
}

