/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;

final class StripeButtonUI
extends MetalToggleButtonUI {
    private static final StripeButtonUI ourInstance = new StripeButtonUI();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle();
    private static Insets ourViewInsets = new Insets(0, 0, 0, 0);

    private StripeButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return ourInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        StripeButton button = (StripeButton)c;
        Dimension dim = super.getPreferredSize(button);
        dim.width = (int)(4.0f + (float)dim.width * 1.1f);
        dim.height += 4;
        ToolWindowAnchor anchor = button.getWindowInfo().getAnchor();
        if (ToolWindowAnchor.LEFT == anchor || ToolWindowAnchor.RIGHT == anchor) {
            return new Dimension(dim.height, dim.width);
        }
        return dim;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GradientPaint paint;
        Graphics2D g2d;
        Icon icon;
        StripeButton button = (StripeButton)c;
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = button.getFontMetrics(button.getFont());
        ourViewInsets = c.getInsets(ourViewInsets);
        StripeButtonUI.ourViewRect.x = StripeButtonUI.ourViewInsets.left;
        StripeButtonUI.ourViewRect.y = StripeButtonUI.ourViewInsets.top;
        ToolWindowAnchor anchor = button.getWindowInfo().getAnchor();
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            StripeButtonUI.ourViewRect.height = c.getWidth() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c.getHeight() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        } else {
            StripeButtonUI.ourViewRect.height = c.getHeight() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c.getWidth() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        }
        StripeButtonUI.ourIconRect.height = 0;
        StripeButtonUI.ourIconRect.width = 0;
        StripeButtonUI.ourIconRect.y = 0;
        StripeButtonUI.ourIconRect.x = 0;
        StripeButtonUI.ourTextRect.height = 0;
        StripeButtonUI.ourTextRect.width = 0;
        StripeButtonUI.ourTextRect.y = 0;
        StripeButtonUI.ourTextRect.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(c, fm, text, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, button.getText() == null ? 0 : button.getIconTextGap());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ButtonModel model = button.getModel();
        Color background = button.getBackground();
        boolean toFill = true;
        boolean toBorder = true;
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            g2d = (Graphics2D)g;
            paint = ToolWindowAnchor.TOP == anchor || ToolWindowAnchor.BOTTOM == anchor ? new GradientPaint(0.0f, 0.0f, background.darker(), 0.0f, button.getHeight(), background.brighter()) : new GradientPaint(0.0f, 0.0f, background.darker(), button.getWidth(), 0.0f, background.brighter());
            g2d.setPaint(paint);
            if (toFill) {
                g2d.fillRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
            if (toBorder) {
                g.setColor(Color.black);
                g.drawRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
        } else {
            if (toFill) {
                g.setColor(background);
                g.fillRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
            if (toBorder) {
                g.setColor(Color.GRAY);
                g.drawRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
        }
        if (model.isRollover()) {
            if (!(model.isArmed() || model.isPressed() || model.isSelected())) {
                g2d = (Graphics2D)g;
                paint = ToolWindowAnchor.TOP == anchor || ToolWindowAnchor.BOTTOM == anchor ? new GradientPaint(0.0f, 0.0f, background, 0.0f, button.getHeight(), Color.white) : new GradientPaint(0.0f, 0.0f, background, button.getWidth(), 0.0f, Color.white);
                g2d.setPaint(paint);
                g2d.fillRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
            if (toBorder) {
                g.setColor(Color.darkGray);
                g.drawRoundRect(3, 3, button.getWidth() - 6, button.getHeight() - 6, 5, 5);
            }
        }
        AffineTransform tr = null;
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            tr = g2.getTransform();
            if (ToolWindowAnchor.RIGHT == anchor) {
                if (icon != null) {
                    icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.y, StripeButtonUI.ourIconRect.x);
                }
                g2.rotate(1.5707963267948966);
                g2.translate(0, -c.getWidth());
            } else {
                if (icon != null) {
                    icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.y, c.getHeight() - StripeButtonUI.ourIconRect.x - icon.getIconHeight());
                }
                g2.rotate(-1.5707963267948966);
                g2.translate(-c.getHeight(), 0);
            }
        } else if (icon != null) {
            icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.x, StripeButtonUI.ourIconRect.y);
        }
        if (text != null) {
            if (model.isEnabled()) {
                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    g.setColor(background);
                } else {
                    g.setColor(button.getForeground());
                }
            } else {
                g.setColor(background.darker());
            }
            if (model.isEnabled()) {
                g.setColor(button.getForeground());
                BasicGraphicsUtils.drawString(g, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            } else {
                if (model.isSelected()) {
                    g.setColor(c.getBackground());
                } else {
                    g.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            }
        }
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            g2.setTransform(tr);
        }
    }
}

