/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public final class StripeButton
extends JToggleButton
implements ActionListener {
    private final Color ourBackgroundColor = new Color(247, 243, 239);
    private int myMnemonic;
    private final InternalDecorator myDecorator;
    private final MyPropertyChangeListener myToolWindowHandler;
    private boolean myPressedWhenSelected;
    private JLayeredPane myDragPane;
    private final ToolWindowsPane myPane;
    private JLabel myDragButtonImage;
    private Point myPressedPoint;
    private Stripe myLastStripe;

    StripeButton(InternalDecorator decorator, ToolWindowsPane pane) {
        this.myDecorator = decorator;
        this.myToolWindowHandler = new MyPropertyChangeListener();
        this.myPane = pane;
        this.init();
    }

    @Override
    public void setMnemonic(int mnemonic) {
        throw new UnsupportedOperationException("use setMnemonic2(int)");
    }

    private void setMnemonic2(int mnemonic) {
        this.myMnemonic = mnemonic;
        this.revalidate();
        this.repaint();
    }

    public int getMnemonic2() {
        return this.myMnemonic;
    }

    WindowInfoImpl getWindowInfo() {
        return this.myDecorator.getWindowInfo();
    }

    private void init() {
        this.setFocusable(false);
        this.setBackground(this.ourBackgroundColor);
        Border border = BorderFactory.createEmptyBorder(5, 5, 0, 5);
        this.setBorder(border);
        this.updateText();
        this.updateState();
        this.apply(this.myDecorator.getWindowInfo());
        this.myDecorator.getToolWindow().addPropertyChangeListener(this.myToolWindowHandler);
        this.addActionListener(this);
        this.addMouseListener((MouseListener)((Object)new MyPopupHandler()));
        this.setRolloverEnabled(true);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                StripeButton.this.processDrag(e);
            }
        });
    }

    public InternalDecorator getDecorator() {
        return this.myDecorator;
    }

    private void processDrag(MouseEvent e) {
        if (!this.isDraggingNow()) {
            if (this.myPressedPoint == null) {
                return;
            }
            if (this.isWithinDeadZone(e)) {
                return;
            }
            this.myDragPane = StripeButton.findLayeredPane(e);
            if (this.myDragPane == null) {
                return;
            }
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.paint(image.getGraphics());
            this.myDragButtonImage = new JLabel(new ImageIcon(image)){

                @Override
                public String toString() {
                    return "Image for: " + StripeButton.this.toString();
                }
            };
            this.myDragPane.add((Component)this.myDragButtonImage, JLayeredPane.POPUP_LAYER);
            this.myDragButtonImage.setSize(this.myDragButtonImage.getPreferredSize());
            this.setVisible(false);
            this.myPane.startDrag();
        }
        if (!this.isDraggingNow()) {
            return;
        }
        Point xy = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myDragPane);
        if (this.myPressedPoint != null) {
            xy.x -= this.myPressedPoint.x;
            xy.y -= this.myPressedPoint.y;
        }
        this.myDragButtonImage.setLocation(xy);
        SwingUtilities.convertPointToScreen(xy, this.myDragPane);
        Stripe stripe = this.myPane.getStripeFor(new Rectangle(xy, this.myDragButtonImage.getSize()), (Stripe)this.getParent());
        if (stripe == null) {
            if (this.myLastStripe != null) {
                this.myLastStripe.resetDrop();
            }
        } else {
            if (this.myLastStripe != null && this.myLastStripe != stripe) {
                this.myLastStripe.resetDrop();
            }
            stripe.processDropButton(this, this.myDragButtonImage, xy);
        }
        this.myLastStripe = stripe;
    }

    private boolean isWithinDeadZone(MouseEvent e) {
        return Math.abs(this.myPressedPoint.x - e.getPoint().x) < 7 && Math.abs(this.myPressedPoint.y - e.getPoint().y) < 7;
    }

    @Nullable
    private static JLayeredPane findLayeredPane(MouseEvent e) {
        if (!(e.getComponent() instanceof JComponent)) {
            return null;
        }
        JRootPane root = ((JComponent)e.getComponent()).getRootPane();
        return root.getLayeredPane();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger() && e.getComponent().isShowing()) {
            super.processMouseEvent(e);
            return;
        }
        if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.myDecorator.fireHiddenSide();
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        if (501 == e.getID()) {
            this.myPressedPoint = e.getPoint();
            this.myPressedWhenSelected = this.isSelected();
        } else if (502 == e.getID()) {
            this.finishDragging();
            this.myPressedPoint = null;
            this.myDragButtonImage = null;
        }
        super.processMouseEvent(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myPressedWhenSelected) {
            this.myDecorator.fireHidden();
        } else {
            this.myDecorator.fireActivated();
        }
        this.myPressedWhenSelected = false;
    }

    public void apply(WindowInfoImpl info) {
        this.setSelected(info.isVisible() || info.isActive());
    }

    void dispose() {
        this.myDecorator.getToolWindow().removePropertyChangeListener(this.myToolWindowHandler);
    }

    private void showPopup(Component component, int x, int y) {
        ActionGroup group = this.myDecorator.createPopupGroup();
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", group);
        popupMenu.getComponent().show(component, x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(StripeButtonUI.createUI(this));
        Font font = UIUtil.getButtonFont();
        if (font.getSize() % 2 == 1) {
            font = font.deriveFont(font.getStyle(), font.getSize() - 1);
        }
        this.setFont(font);
    }

    void updateText() {
        String toolWindowId;
        String text = toolWindowId = this.getWindowInfo().getId();
        if (UISettings.getInstance().SHOW_TOOL_WINDOW_NUMBERS) {
            int mnemonic = ActivateToolWindowAction.getMnemonicForToolWindow(toolWindowId);
            if (mnemonic != -1) {
                text = (char)mnemonic + ": " + text;
                this.setMnemonic2(mnemonic);
            } else {
                this.setMnemonic2(0);
            }
        }
        this.setText(text);
    }

    void updateState() {
        boolean toShow;
        ToolWindowImpl window = this.myDecorator.getToolWindow();
        boolean bl = toShow = window.isAvailable() || window.isPlaceholderMode();
        if (UISettings.getInstance().ALWAYS_SHOW_WINDOW_BUTTONS) {
            this.setVisible(true);
        } else {
            this.setVisible(toShow);
        }
        this.setEnabled(toShow && !window.isPlaceholderMode());
    }

    private boolean isDraggingNow() {
        return this.myDragButtonImage != null;
    }

    private void finishDragging() {
        if (!this.isDraggingNow()) {
            return;
        }
        this.myDragPane.remove(this.myDragButtonImage);
        this.myDragButtonImage = null;
        this.myPane.stopDrag();
        this.myDragPane.repaint();
        this.setVisible(true);
        if (this.myLastStripe != null) {
            this.myLastStripe.finishDrop();
            this.myLastStripe = null;
        }
    }

    @Override
    public String toString() {
        return StringUtil.getShortName((String)this.getClass().getName()) + " text: " + this.getText();
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("available".equals(name)) {
                StripeButton.this.updateState();
            } else if ("title".equals(name)) {
                StripeButton.this.updateText();
            } else if ("icon".equals(name)) {
                Icon icon = (Icon)e.getNewValue();
                Icon disabledIcon = IconLoader.getDisabledIcon((Icon)icon);
                StripeButton.this.setIcon(icon);
                StripeButton.this.setDisabledIcon(disabledIcon);
            }
        }
    }

    private final class MyPopupHandler
    extends PopupHandler {
        private MyPopupHandler() {
        }

        public void invokePopup(Component component, int x, int y) {
            StripeButton.this.showPopup(component, x, y);
        }
    }
}

