/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.util.Iterator;
import java.util.Stack;

final class ActiveStack {
    private final Stack<String> myStack = new Stack();
    private final Stack<String> myPersistentStack = new Stack();

    ActiveStack() {
    }

    void clear() {
        this.myStack.clear();
    }

    boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    String pop() {
        return this.myStack.pop();
    }

    String peek() {
        return this.myStack.peek();
    }

    void push(String id) {
        this.remove(id, true);
        this.myStack.push(id);
        this.myPersistentStack.push(id);
    }

    int getPersistentSize() {
        return this.myPersistentStack.size();
    }

    String peekPersistent(int index) {
        return (String)this.myPersistentStack.get(this.myPersistentStack.size() - index - 1);
    }

    void remove(String id, boolean removePersistentAlso) {
        Iterator i = this.myStack.iterator();
        while (i.hasNext()) {
            if (!id.equals(i.next())) continue;
            i.remove();
        }
        if (removePersistentAlso) {
            i = this.myPersistentStack.iterator();
            while (i.hasNext()) {
                if (!id.equals(i.next())) continue;
                i.remove();
            }
        }
    }
}

