/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private final NewVirtualFileSystem myFS;
    private Object myChildren;

    public VirtualDirectoryImpl(String name, VirtualDirectoryImpl parent, NewVirtualFileSystem fs, int id) {
        super(name, parent, id);
        this.myFS = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFS;
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getFileSystem must not return null");
        }
        return newVirtualFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NewVirtualFile findChild(String name, boolean createIfNotFound, boolean ensureCanonicalName) {
        NewVirtualFile result = this.doFindChild(name, createIfNotFound, ensureCanonicalName);
        VirtualDirectoryImpl virtualDirectoryImpl = this;
        synchronized (virtualDirectoryImpl) {
            if (result == null && this.myChildren instanceof Map) {
                this.ensureAsMap().put(name, (VirtualFile)NullVirtualFile.INSTANCE);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NewVirtualFile doFindChild(String name, boolean createIfNotFound, boolean ensureCanonicalName) {
        VirtualFile file;
        Map<String, VirtualFile> map;
        if (name.length() == 0) {
            return null;
        }
        VirtualFile[] a = this.asArray();
        if (a != null) {
            for (VirtualFile file2 : a) {
                if (!this.namesEqual(name, file2.getName())) continue;
                return (NewVirtualFile)file2;
            }
            return createIfNotFound ? this.createAndFindChildWithEventFire(name) : null;
        }
        VirtualDirectoryImpl i$ = this;
        synchronized (i$) {
            map = this.ensureAsMap();
            file = map.get(name);
        }
        if (file == NullVirtualFile.INSTANCE) {
            return createIfNotFound ? this.createAndFindChildWithEventFire(name) : null;
        }
        if (file != null) {
            return (NewVirtualFile)file;
        }
        if (ensureCanonicalName) {
            NewVirtualFileSystem delegate = this.getFileSystem();
            FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
            name = delegate.getCanonicallyCasedName((VirtualFile)fake);
        }
        VirtualDirectoryImpl virtualDirectoryImpl = this;
        synchronized (virtualDirectoryImpl) {
            int id = ourPersistence.getId((VirtualFile)this, name);
            if (id > 0) {
                VirtualFileSystemEntry child = this.createChild(name, id);
                map.put(name, (VirtualFile)child);
                return child;
            }
        }
        return null;
    }

    public VirtualFileSystemEntry createChild(String name, int id) {
        NewVirtualFileSystem fs = this.getFileSystem();
        VirtualFileSystemEntry child = ourPersistence.isDirectory(id) ? new VirtualDirectoryImpl(name, this, fs, id) : new VirtualFileImpl(name, this, id);
        if (fs.markNewFilesAsDirty()) {
            child.markDirty();
        }
        return child;
    }

    @Nullable
    private NewVirtualFile createAndFindChildWithEventFire(String name) {
        FakeVirtualFile fake;
        NewVirtualFileSystem delegate = this.getFileSystem();
        if (delegate.exists((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))) {
            String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
            VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, delegate.isDirectory((VirtualFile)fake), true);
            RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
            return this.findChild(realName);
        }
        return null;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(String name) {
        return this.findChild(name, true, true);
    }

    @Nullable
    public synchronized NewVirtualFile findChildIfCached(String name) {
        VirtualFile[] a = this.asArray();
        if (a != null) {
            for (VirtualFile file : a) {
                if (!this.namesEqual(name, file.getName())) continue;
                return (NewVirtualFile)file;
            }
            return null;
        }
        Map<String, VirtualFile> map = this.asMap();
        if (map != null) {
            VirtualFile file = map.get(name);
            return file instanceof NewVirtualFile ? (NewVirtualFile)file : null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public synchronized Collection<VirtualFile> getInDbChildren() {
        String[] names;
        List<Object> list;
        if (this.myChildren instanceof VirtualFile[]) {
            list = Arrays.asList((VirtualFile[])this.myChildren);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getInDbChildren must not return null");
            return list;
        }
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getInDbChildren must not return null");
            return list;
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            list = Arrays.asList(this.getChildren());
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getInDbChildren must not return null");
            return list;
        }
        for (String name : names = ourPersistence.listPersisted((VirtualFile)this)) {
            this.findChild(name, false, false);
        }
        list = new ArrayList<VirtualFile>(this.ensureAsMap().values());
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getInDbChildren must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public synchronized VirtualFile[] getChildren() {
        VirtualFile[] children;
        VirtualFile[] virtualFileArray;
        if (this.myChildren instanceof VirtualFile[]) {
            virtualFileArray = (VirtualFile[])this.myChildren;
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getChildren must not return null");
            return virtualFileArray;
        }
        int[] childrenIds = ourPersistence.listIds((VirtualFile)this);
        if (childrenIds.length == 0) {
            children = EMPTY_ARRAY;
        } else {
            children = new VirtualFile[childrenIds.length];
            Map<String, VirtualFile> map = this.asMap();
            for (int i = 0; i < children.length; ++i) {
                int childId = childrenIds[i];
                String name = ourPersistence.getName(childId);
                VirtualFile child = map != null ? map.get(name) : null;
                children[i] = child != null && child != NullVirtualFile.INSTANCE ? child : this.createChild(name, childId);
            }
        }
        if (this.getId() > 0) {
            this.myChildren = children;
        }
        virtualFileArray = children;
        if (children != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getChildren must not return null");
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.findChild must not be null");
        }
        return this.findChild(name, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NewVirtualFile findChildById(int id) {
        VirtualFile[] a = this.asArray();
        if (a != null) {
            for (VirtualFile file : a) {
                NewVirtualFile withId = (NewVirtualFile)file;
                if (withId.getId() != id) continue;
                return withId;
            }
            return null;
        }
        VirtualDirectoryImpl arr$ = this;
        synchronized (arr$) {
            Map<String, VirtualFile> map = this.asMap();
            if (map != null) {
                for (Map.Entry<String, VirtualFile> entry : map.entrySet()) {
                    NewVirtualFile withId;
                    VirtualFile file = entry.getValue();
                    if (file == NullVirtualFile.INSTANCE || (withId = (NewVirtualFile)file).getId() != id) continue;
                    return withId;
                }
            }
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false);
    }

    @Nullable
    private synchronized VirtualFile[] asArray() {
        if (this.myChildren instanceof VirtualFile[]) {
            return (VirtualFile[])this.myChildren;
        }
        return null;
    }

    @Nullable
    private synchronized Map<String, VirtualFile> asMap() {
        if (this.myChildren instanceof Map) {
            return (Map)this.myChildren;
        }
        return null;
    }

    @NotNull
    private synchronized Map<String, VirtualFile> ensureAsMap() {
        Map map;
        if (this.myChildren == null) {
            map = this.createMap();
            this.myChildren = map;
        } else {
            map = (Map)this.myChildren;
        }
        Map map2 = map;
        if (map2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.ensureAsMap must not return null");
        }
        return map2;
    }

    public synchronized void addChild(VirtualFile file) {
        Object[] a = this.asArray();
        if (a != null) {
            this.myChildren = ArrayUtil.append((Object[])a, (Object)file);
        } else {
            Map<String, VirtualFile> m = this.ensureAsMap();
            m.put(file.getName(), file);
        }
    }

    public synchronized void removeChild(VirtualFile file) {
        Object[] a = this.asArray();
        if (a != null) {
            this.myChildren = ArrayUtil.remove((Object[])a, (Object)file);
        } else {
            Map<String, VirtualFile> m = this.ensureAsMap();
            m.put(file.getName(), (VirtualFile)NullVirtualFile.INSTANCE);
        }
    }

    public synchronized boolean allChildrenLoaded() {
        return this.myChildren instanceof VirtualFile[];
    }

    public synchronized List<String> getSuspicousNames() {
        Map<String, VirtualFile> map = this.asMap();
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, VirtualFile> entry : map.entrySet()) {
            if (entry.getValue() != NullVirtualFile.INSTANCE) continue;
            names.add(entry.getKey());
        }
        return names;
    }

    public boolean isDirectory() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public synchronized Collection<VirtualFile> getCachedChildren() {
        List<Object> list;
        Map<String, VirtualFile> map = this.asMap();
        if (map != null) {
            THashSet files = new THashSet(map.values());
            files.remove(NullVirtualFile.INSTANCE);
            list = files;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getCachedChildren must not return null");
            return list;
        }
        VirtualFile[] a = this.asArray();
        if (a != null) {
            list = Arrays.asList(a);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getCachedChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl.getCachedChildren must not return null");
    }

    private boolean namesEqual(String name1, String name2) {
        return this.getFileSystem().isCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    private Map<String, VirtualFile> createMap() {
        return this.getFileSystem().isCaseSensitive() ? new THashMap() : new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    public synchronized void cleanupCachedChildren() {
        this.myChildren = null;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }
}

