/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.win32.Win32Kernel;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Win32LocalFileSystem
extends LocalFileSystemBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem");
    private static boolean ourIsAvailable;
    private static final ThreadLocal<Win32LocalFileSystem> THREAD_LOCAL;
    private final Win32Kernel myKernel = new Win32Kernel();
    public static boolean checkMe;

    public static boolean isAvailable() {
        return ourIsAvailable;
    }

    public static Win32LocalFileSystem getWin32Instance() {
        if (!Win32LocalFileSystem.isAvailable()) {
            throw new RuntimeException("dll is not loaded");
        }
        Win32LocalFileSystem fileSystem = THREAD_LOCAL.get();
        fileSystem.myKernel.clearCache();
        return fileSystem;
    }

    private Win32LocalFileSystem() {
    }

    @Override
    public String[] list(VirtualFile file) {
        try {
            String[] strings = this.myKernel.list(file.getPath());
            if (checkMe && !((Object)Arrays.asList(strings)).equals(Arrays.asList(super.list(file)))) {
                LOG.error(file.getPath());
            }
            return strings;
        }
        catch (Exception e) {
            if (checkMe) assert (false);
            return super.list(file);
        }
    }

    @Override
    public boolean exists(VirtualFile fileOrDirectory) {
        if (fileOrDirectory.getParent() == null) {
            return true;
        }
        try {
            this.myKernel.exists(fileOrDirectory.getPath());
            if (checkMe && !super.exists(fileOrDirectory)) {
                LOG.error(fileOrDirectory.getPath());
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return super.exists(fileOrDirectory);
        }
    }

    @Override
    public boolean isDirectory(VirtualFile file) {
        try {
            boolean b = this.myKernel.isDirectory(file.getPath());
            if (checkMe && b != super.isDirectory(file)) {
                LOG.error(file.getPath());
            }
            return b;
        }
        catch (FileNotFoundException e) {
            return super.isDirectory(file);
        }
    }

    @Override
    public boolean isWritable(VirtualFile file) {
        try {
            boolean b = this.myKernel.isWritable(file.getPath());
            if (checkMe && b != super.isWritable(file)) {
                LOG.error(file.getPath());
            }
            return b;
        }
        catch (FileNotFoundException e) {
            return super.isWritable(file);
        }
    }

    @Override
    public long getTimeStamp(VirtualFile file) {
        try {
            long timeStamp = this.myKernel.getTimeStamp(file.getPath());
            if (checkMe && timeStamp != super.getTimeStamp(file)) {
                timeStamp = this.myKernel.getTimeStamp(file.getPath());
                LOG.error(file.getPath());
            }
            return timeStamp;
        }
        catch (FileNotFoundException e) {
            return super.getTimeStamp(file);
        }
    }

    public LocalFileSystem.WatchRequest addRootToWatch(@NotNull String rootPath, boolean toWatchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem.addRootToWatch must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean toWatchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem.addRootsToWatch must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> rootsToWatch) {
        if (rootsToWatch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem.removeWatchedRoots must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void removeWatchedRoot(@NotNull LocalFileSystem.WatchRequest watchRequest) {
        if (watchRequest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem.removeWatchedRoot must not be null");
        }
        throw new UnsupportedOperationException();
    }

    static {
        try {
            System.loadLibrary("IdeaWin32");
            ourIsAvailable = true;
        }
        catch (Throwable e) {
            ourIsAvailable = false;
        }
        THREAD_LOCAL = new ThreadLocal<Win32LocalFileSystem>(){

            @Override
            protected Win32LocalFileSystem initialValue() {
                return new Win32LocalFileSystem();
            }
        };
        checkMe = false;
    }
}

