/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileInfo
implements RemoteContentProvider.DownloadingCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.RemoteFileInfo");
    private final Object myLock;
    private final String myUrl;
    private final RemoteFileManager myManager;
    @Nullable
    private RemoteContentProvider myContentProvider;
    private File myLocalFile;
    private VirtualFile myLocalVirtualFile;
    private VirtualFile myPrevLocalFile;
    private RemoteFileState myState;
    private String myErrorMessage;
    private final AtomicBoolean myCancelled;
    private final List<FileDownloadingListener> myListeners;

    public RemoteFileInfo(@NotNull String url, @NotNull RemoteFileManager manager) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.<init> must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.<init> must not be null");
        }
        this.myLock = new Object();
        this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
        this.myCancelled = new AtomicBoolean();
        this.myListeners = new SmartList();
        this.myUrl = url;
        this.myManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadingListener(@NotNull FileDownloadingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.addDownloadingListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadingListener(@NotNull FileDownloadingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.removeDownloadingListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener);
        }
    }

    public String getUrl() {
        return this.myUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartDownloading() {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrorMessage = null;
            this.myPrevLocalFile = this.myLocalVirtualFile;
            this.myLocalVirtualFile = null;
            this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
            this.myLocalFile = null;
            this.startDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownloading() {
        FileDownloadingListener[] listeners;
        File localFile;
        LOG.debug("Downloading requested");
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState != RemoteFileState.DOWNLOADING_NOT_STARTED) {
                LOG.debug("File already downloaded: file = " + this.myLocalVirtualFile + ", state = " + (Object)((Object)this.myState));
                return;
            }
            this.myState = RemoteFileState.DOWNLOADING_IN_PROGRESS;
            try {
                this.myLocalFile = this.myManager.getStorage().createLocalFile(this.myUrl);
                LOG.debug("Local file created: " + this.myLocalFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.errorOccurred(VfsBundle.message((String)"cannot.create.local.file", (Object[])new Object[]{e.getMessage()}), false);
                return;
            }
            this.myCancelled.set(false);
            localFile = this.myLocalFile;
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            listener.downloadingStarted();
        }
        if (this.myContentProvider == null) {
            this.myContentProvider = HttpFileSystemImpl.getInstanceImpl().findContentProvider(this.myUrl);
        }
        this.myContentProvider.saveContent(this.myUrl, localFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(@Nullable FileType fileType) {
        FileDownloadingListener[] listeners;
        File localIOFile;
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("Downloading finished, size = " + this.myLocalFile.length() + ", file type=" + (fileType != null ? fileType.getName() : "null"));
            if (fileType != null) {
                String fileName = this.myLocalFile.getName();
                int dot = fileName.lastIndexOf(46);
                String extension = fileType.getDefaultExtension();
                if (dot == -1 || !extension.equals(fileName.substring(dot + 1))) {
                    File newFile = FileUtil.findSequentNonexistentFile((File)this.myLocalFile.getParentFile(), (String)fileName, (String)extension);
                    try {
                        FileUtil.rename((File)this.myLocalFile, (File)newFile);
                        this.myLocalFile = newFile;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            localIOFile = this.myLocalFile;
        }
        VirtualFile localFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(Result<VirtualFile> result) {
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(localIOFile);
                if (file != null) {
                    file.refresh(false, false);
                }
                result.setResult((Object)file);
            }
        }.execute().getResultObject();
        LOG.assertTrue(localFile != null, (Object)("Virtual local file not found for " + localIOFile.getAbsolutePath()));
        LOG.debug("Virtual local file: " + localFile + ", size = " + localFile.getLength());
        Object dot = this.myLock;
        synchronized (dot) {
            this.myLocalVirtualFile = localFile;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.DOWNLOADED;
            this.myErrorMessage = null;
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            listener.fileDownloaded(localFile);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessage() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOccurred(@NotNull String errorMessage, boolean cancelled) {
        FileDownloadingListener[] listeners;
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.errorOccurred must not be null");
        }
        LOG.debug("Error: " + errorMessage);
        Object object = this.myLock;
        synchronized (object) {
            this.myLocalVirtualFile = null;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.ERROR_OCCURRED;
            this.myErrorMessage = errorMessage;
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            if (cancelled) continue;
            listener.errorOccurred(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgressFraction(double fraction) {
        FileDownloadingListener[] listeners;
        Object object = this.myLock;
        synchronized (object) {
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            listener.progressFractionChanged(fraction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgressText(@NotNull String text, boolean indeterminate) {
        FileDownloadingListener[] listeners;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo.setProgressText must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            listener.progressMessageChanged(indeterminate, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile getLocalFile() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myLocalVirtualFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileState getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownloading() {
        FileDownloadingListener[] listeners;
        Object object = this.myLock;
        synchronized (object) {
            this.myCancelled.set(true);
            if (this.myPrevLocalFile != null) {
                this.myLocalVirtualFile = this.myPrevLocalFile;
                this.myLocalFile = VfsUtil.virtualToIoFile((VirtualFile)this.myLocalVirtualFile);
                this.myState = RemoteFileState.DOWNLOADED;
                this.myErrorMessage = null;
            } else {
                this.myState = RemoteFileState.ERROR_OCCURRED;
            }
            listeners = this.myListeners.toArray(new FileDownloadingListener[this.myListeners.size()]);
        }
        for (FileDownloadingListener listener : listeners) {
            listener.downloadingCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable postRunnable) {
        VirtualFile localVirtualFile;
        Object object = this.myLock;
        synchronized (object) {
            localVirtualFile = this.myLocalVirtualFile;
        }
        RemoteContentProvider contentProvider = HttpFileSystemImpl.getInstanceImpl().findContentProvider(this.myUrl);
        if (localVirtualFile == null || !contentProvider.equals(this.myContentProvider) || !contentProvider.isUpToDate(this.myUrl, localVirtualFile)) {
            this.myContentProvider = contentProvider;
            this.addDownloadingListener(new MyRefreshingDownloadingListener(postRunnable));
            this.restartDownloading();
        }
    }

    private class MyRefreshingDownloadingListener
    extends FileDownloadingAdapter {
        private final Runnable myPostRunnable;

        public MyRefreshingDownloadingListener(Runnable postRunnable) {
            this.myPostRunnable = postRunnable;
        }

        @Override
        public void downloadingCancelled() {
            RemoteFileInfo.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileInfo.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileInfo$MyRefreshingDownloadingListener.errorOccurred must not be null");
            }
            RemoteFileInfo.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }
    }
}

