/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class LocalFileStorage {
    private final File myStorageIODirectory = new File(PathManager.getSystemPath(), "httpFileSystem");

    public LocalFileStorage() {
        this.myStorageIODirectory.mkdirs();
    }

    public File createLocalFile(@NotNull String url) throws IOException {
        int last;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/LocalFileStorage.createLocalFile must not be null");
        }
        int ast = url.indexOf(63);
        if (ast != -1) {
            url = url.substring(0, ast);
        }
        String baseName = (last = url.lastIndexOf(47)) == url.length() - 1 ? url.substring(url.lastIndexOf(47, last - 1) + 1, last) : url.substring(last + 1);
        int index = baseName.lastIndexOf(46);
        String prefix = index == -1 ? baseName : baseName.substring(0, index);
        String suffix = index == -1 ? "" : baseName.substring(index + 1);
        prefix = PathUtil.suggestFileName((String)prefix);
        suffix = PathUtil.suggestFileName((String)suffix);
        File file = FileUtil.findSequentNonexistentFile((File)this.myStorageIODirectory, (String)prefix, (String)suffix);
        FileUtil.createIfDoesntExist((File)file);
        return file;
    }

    public void deleteDownloadedFiles() {
        FileUtil.delete((File)this.myStorageIODirectory);
    }
}

