/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider");
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;

    @Override
    public boolean canProvideContent(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider.canProvideContent must not be null");
        }
        return true;
    }

    @Override
    public void saveContent(final String url, final @NotNull File file, final @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider.saveContent must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider.saveContent must not be null");
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                DefaultRemoteContentProvider.downloadContent(url, file, callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadContent(String url, File file, RemoteContentProvider.DownloadingCallback callback) {
        HttpConfigurable.getInstance().setAuthenticator();
        LOG.debug("Downloading started: " + url);
        InputStream input = null;
        OutputStream output = null;
        try {
            int len;
            String presentableUrl = StringUtil.first((String)url, (int)40, (boolean)true);
            callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            input = UrlConnectionUtil.getConnectionInputStreamWithException(connection, (ProgressIndicator)new EmptyProgressIndicator());
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
            }
            int size = connection.getContentLength();
            output = new BufferedOutputStream(new FileOutputStream(file));
            callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
            if (size != -1) {
                callback.setProgressFraction(0.0);
            }
            String contentType = connection.getContentType();
            FileType fileType = RemoteFileUtil.getFileType(contentType);
            byte[] buf = new byte[1024];
            int count = 0;
            while ((len = input.read(buf)) > 0) {
                if (callback.isCancelled()) {
                    return;
                }
                count += len;
                if (size > 0) {
                    callback.setProgressFraction((double)count / (double)size);
                }
                output.write(buf, 0, len);
            }
            output.close();
            output = null;
            LOG.debug("Downloading finished, " + size + " bytes downloaded");
            callback.finished(fileType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isUpToDate(@NotNull String url, @NotNull VirtualFile local) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider.isUpToDate must not be null");
        }
        if (local == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider.isUpToDate must not be null");
        }
        return false;
    }
}

