/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePointerImpl
extends UserDataHolderBase
implements VirtualFilePointer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerImpl");
    private String myUrl;
    private VirtualFile myFile;
    private final VirtualFileManager myVirtualFileManager;
    private final VirtualFilePointerListener myListener;
    private boolean disposed;
    int useCount;
    private long myLastUpdated;
    private static final Key<Throwable> CREATE_TRACE = Key.create((String)"CREATION_TRACE");
    private static final Key<Throwable> KILL_TRACE = Key.create((String)"KILL_TRACE");
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled();

    VirtualFilePointerImpl(VirtualFile file, @NotNull String url, @NotNull VirtualFileManager virtualFileManager, VirtualFilePointerListener listener, @NotNull Disposable parentDisposable) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.<init> must not be null");
        }
        if (virtualFileManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.<init> must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.<init> must not be null");
        }
        this.disposed = false;
        this.myLastUpdated = -1L;
        this.myFile = file;
        this.myUrl = url;
        this.myVirtualFileManager = virtualFileManager;
        this.myListener = listener;
        this.useCount = 0;
        if (TRACE_CREATION) {
            this.putUserData(CREATE_TRACE, new Throwable("parent = '" + parentDisposable + "' (" + parentDisposable.getClass() + ")"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFileName() {
        String string;
        this.update();
        if (this.myFile != null) {
            string = this.myFile.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.getFileName must not return null");
            return string;
        }
        int index = this.myUrl.lastIndexOf(47);
        string = index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.getFileName must not return null");
    }

    public VirtualFile getFile() {
        this.checkDisposed();
        this.update();
        if (this.myFile != null && !this.myFile.isValid()) {
            this.myUrl = this.myFile.getUrl();
            this.myFile = null;
            this.update();
        }
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        this.update();
        String string = this.myUrl == null ? this.myFile.getUrl() : this.myUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.getUrl must not return null");
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        this.checkDisposed();
        this.update();
        String string = PathUtil.toPresentableUrl((String)this.getUrl());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerImpl.getPresentableUrl must not return null");
        }
        return string;
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new MyException("Already disposed: " + this.toString(), (Throwable)this.getUserData(CREATE_TRACE), (Throwable)this.getUserData(KILL_TRACE));
        }
    }

    public void throwNotDisposedError(String msg) throws RuntimeException {
        Throwable trace = (Throwable)this.getUserData(CREATE_TRACE);
        throw new RuntimeException(msg + "\n" + "url=" + (Object)((Object)this) + "\nCreation trace " + (trace == null ? "null" : "some") + "\n", trace);
    }

    public int incrementUsageCount() {
        return ++this.useCount;
    }

    public boolean isValid() {
        this.update();
        return !this.disposed && this.myFile != null;
    }

    void update() {
        if (this.disposed) {
            return;
        }
        long fsModCount = this.myVirtualFileManager.getModificationCount();
        if (this.myLastUpdated == fsModCount) {
            return;
        }
        this.myLastUpdated = fsModCount;
        if (this.myFile == null) {
            LOG.assertTrue(this.myUrl != null, (Object)"Both file & url are null");
            this.myFile = this.myVirtualFileManager.findFileByUrl(this.myUrl);
            if (this.myFile != null) {
                this.myUrl = null;
            }
        } else if (!this.myFile.exists()) {
            this.myUrl = this.myFile.getUrl();
            this.myFile = null;
        }
    }

    public String toString() {
        return this.myFile == null ? this.myUrl : this.myFile.getUrl();
    }

    public void dispose() {
        if (this.disposed) {
            throw new MyException("Punching the dead horse.\nurl=" + this.toString(), (Throwable)this.getUserData(CREATE_TRACE), (Throwable)this.getUserData(KILL_TRACE));
        }
        if (--this.useCount == 0) {
            if (TRACE_CREATION) {
                this.putUserData(KILL_TRACE, new Throwable());
            }
            String url = this.getUrl();
            this.disposed = true;
            ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).clearPointerCaches(url, this.myListener);
        }
    }

    private static class MyException
    extends RuntimeException {
        private final Throwable e1;
        private final Throwable e2;

        private MyException(String message, Throwable e1, Throwable e2) {
            super(message);
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public void printStackTrace(PrintStream s) {
            this.printStackTrace(new PrintWriter(s));
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            super.printStackTrace(s);
            if (this.e1 != null) {
                s.println("--------------Creation trace: ");
                this.e1.printStackTrace(s);
            }
            if (this.e2 != null) {
                s.println("--------------Kill trace: ");
                this.e2.printStackTrace(s);
            }
        }
    }
}

