/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractTreeNode
extends DefaultMutableTreeNode {
    protected static final ArrayList<File> EMPTY_FILE_ARRAY = new ArrayList();
    DefaultTreeModel myTreeModel;
    private JTree myTree;
    private String myErrorText;

    public void setTree(JTree tree) {
        this.myTree = tree;
        if (this.children == null) {
            return;
        }
        for (AbstractTreeNode node : this.children) {
            node.setTree(tree);
        }
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.myTreeModel = treeModel;
        if (this.children == null) {
            return;
        }
        for (AbstractTreeNode node : this.children) {
            node.setTreeModel(treeModel);
        }
    }

    public void setErrorText(String errorText) {
        this.myErrorText = errorText;
    }

    public String getErrorText() {
        return this.myErrorText;
    }

    protected DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        if (this.showStatistics()) {
            result.append(" (");
            result.append(this.getStatistics(this.getItemsCount()));
            result.append(")");
        }
        return result.toString();
    }

    private String getStatistics(int itemsCount) {
        return VcsBundle.message((String)"update.tree.node.size.statistics", (Object[])new Object[]{itemsCount});
    }

    protected abstract String getName();

    protected abstract int getItemsCount();

    protected abstract boolean showStatistics();

    @NonNls
    public abstract Icon getIcon(boolean var1);

    public abstract Collection<VirtualFile> getVirtualFiles();

    public abstract Collection<File> getFiles();

    public abstract SimpleTextAttributes getAttributes();

    public abstract boolean getSupportsDeletion();
}

