/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsBackgroundableComputable;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryProviderBackgroundableProxy {
    private final Project myProject;
    private final VcsHistoryProvider myDelegate;

    public VcsHistoryProviderBackgroundableProxy(Project project, VcsHistoryProvider delegate) {
        this.myDelegate = delegate;
        this.myProject = project;
    }

    public void createSessionFor(final FilePath filePath, Consumer<VcsHistorySession> continuation, @Nullable VcsBackgroundableActions actionKey, boolean silent) {
        ThrowableComputable<VcsHistorySession, VcsException> throwableComputable = new ThrowableComputable<VcsHistorySession, VcsException>(){

            public VcsHistorySession compute() throws VcsException {
                return VcsHistoryProviderBackgroundableProxy.this.myDelegate.createSessionFor(filePath);
            }
        };
        VcsBackgroundableActions resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey;
        Object key = VcsBackgroundableActions.keyFrom(filePath);
        if (silent) {
            VcsBackgroundableComputable.createAndRunSilent(this.myProject, resultingActionKey, key, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), throwableComputable, continuation);
        } else {
            VcsBackgroundableComputable.createAndRun(this.myProject, resultingActionKey, key, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), throwableComputable, continuation, null);
        }
    }

    public void executeAppendableSession(final FilePath filePath, final VcsAppendableHistorySessionPartner partner, @Nullable VcsBackgroundableActions actionKey, boolean silent) {
        VcsBackgroundableActions resultingActionKey;
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
        final BackgroundableActionEnabledHandler handler = vcsManager.getBackgroundableActionHandler(resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey);
        if (handler.isInProgress((Object)resultingActionKey)) {
            return;
        }
        handler.register((Object)resultingActionKey);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/history/VcsHistoryProviderBackgroundableProxy$2.run must not be null");
                }
                try {
                    VcsHistoryProviderBackgroundableProxy.this.myDelegate.reportAppendableHistory(filePath, partner);
                }
                catch (VcsException e) {
                    try {
                        partner.reportException(e);
                    }
                    catch (Throwable throwable) {
                        partner.finished();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                handler.completed((Object)resultingActionKey);
                            }
                        }, ModalityState.NON_MODAL);
                        throw throwable;
                    }
                    partner.finished();
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                }
                partner.finished();
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
            }
        });
    }
}

