/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.checkout.CheckoutAction;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class CheckoutActionGroup
extends ActionGroup {
    private AnAction[] myChildren;

    public void update(AnActionEvent e) {
        super.update(e);
        CheckoutProvider[] providers = (CheckoutProvider[])Extensions.getExtensions((ExtensionPointName)CheckoutProvider.EXTENSION_POINT_NAME);
        if (providers.length == 0) {
            e.getPresentation().setVisible(false);
        }
    }

    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            CheckoutProvider[] providers = (CheckoutProvider[])Extensions.getExtensions((ExtensionPointName)CheckoutProvider.EXTENSION_POINT_NAME);
            Arrays.sort(providers, new Comparator<CheckoutProvider>(){

                @Override
                public int compare(CheckoutProvider o1, CheckoutProvider o2) {
                    return o1.getVcsName().compareTo(o2.getVcsName());
                }
            });
            this.myChildren = new AnAction[providers.length];
            for (int i = 0; i < providers.length; ++i) {
                CheckoutProvider provider = providers[i];
                this.myChildren[i] = new CheckoutAction(provider);
            }
        }
        return this.myChildren;
    }
}

