/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChange {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChange");
    private final String myPatchPath;
    private final String myBeforePath;
    private final String myAfterPath;
    private final FileStatus myFileStatus;
    private Change myChange;

    public ShelvedChange(String patchPath, String beforePath, String afterPath, FileStatus fileStatus) {
        this.myPatchPath = patchPath;
        this.myBeforePath = beforePath;
        this.myAfterPath = afterPath;
        this.myFileStatus = fileStatus;
    }

    public String getBeforePath() {
        return this.myBeforePath;
    }

    public String getAfterPath() {
        return this.myAfterPath;
    }

    @Nullable
    public String getAfterFileName() {
        if (this.myAfterPath == null) {
            return null;
        }
        int pos = this.myAfterPath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myAfterPath.substring(pos + 1);
        }
        return this.myAfterPath;
    }

    public String getBeforeFileName() {
        int pos = this.myBeforePath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myBeforePath.substring(pos + 1);
        }
        return this.myBeforePath;
    }

    public String getBeforeDirectory() {
        int pos = this.myBeforePath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myBeforePath.substring(0, pos).replace('/', File.separatorChar);
        }
        return File.separator;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    public Change getChange(Project project) {
        if (this.myChange == null) {
            CurrentContentRevision beforeRevision = null;
            PatchedContentRevision afterRevision = null;
            File baseDir = new File(project.getBaseDir().getPath());
            File file = ShelvedChange.getAbsolutePath(baseDir, this.myBeforePath);
            FilePathImpl beforePath = new FilePathImpl(file, false);
            beforePath.refresh();
            if (this.myFileStatus != FileStatus.ADDED) {
                beforeRevision = new CurrentContentRevision(beforePath){

                    @NotNull
                    public VcsRevisionNumber getRevisionNumber() {
                        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                        if (textRevisionNumber == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelvedChange$1.getRevisionNumber must not return null");
                        }
                        return textRevisionNumber;
                    }
                };
            }
            if (this.myFileStatus != FileStatus.DELETED) {
                FilePathImpl afterPath = new FilePathImpl(ShelvedChange.getAbsolutePath(baseDir, this.myAfterPath), false);
                afterRevision = new PatchedContentRevision(beforePath, afterPath);
            }
            this.myChange = new Change((ContentRevision)beforeRevision, afterRevision, this.myFileStatus);
        }
        return this.myChange;
    }

    private static File getAbsolutePath(File baseDir, String relativePath) {
        File file;
        try {
            file = new File(baseDir, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            file = new File(baseDir, relativePath);
        }
        return file;
    }

    @Nullable
    public TextFilePatch loadFilePatch() throws IOException, PatchSyntaxException {
        List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(this.myPatchPath);
        for (TextFilePatch patch : filePatches) {
            if (!this.myBeforePath.equals(patch.getBeforeName())) continue;
            return patch;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShelvedChange)) {
            return false;
        }
        ShelvedChange that = (ShelvedChange)o;
        if (this.myAfterPath != null ? !this.myAfterPath.equals(that.myAfterPath) : that.myAfterPath != null) {
            return false;
        }
        if (this.myBeforePath != null ? !this.myBeforePath.equals(that.myBeforePath) : that.myBeforePath != null) {
            return false;
        }
        if (this.myFileStatus != null ? !this.myFileStatus.equals(that.myFileStatus) : that.myFileStatus != null) {
            return false;
        }
        return !(this.myPatchPath != null ? !this.myPatchPath.equals(that.myPatchPath) : that.myPatchPath != null);
    }

    public int hashCode() {
        int result = this.myPatchPath != null ? this.myPatchPath.hashCode() : 0;
        result = 31 * result + (this.myBeforePath != null ? this.myBeforePath.hashCode() : 0);
        result = 31 * result + (this.myAfterPath != null ? this.myAfterPath.hashCode() : 0);
        result = 31 * result + (this.myFileStatus != null ? this.myFileStatus.hashCode() : 0);
        return result;
    }

    public String getPatchPath() {
        return this.myPatchPath;
    }

    private static class TextRevisionNumber
    implements VcsRevisionNumber {
        private final String myText;

        public TextRevisionNumber(String text) {
            this.myText = text;
        }

        public String asString() {
            return this.myText;
        }

        public int compareTo(VcsRevisionNumber o) {
            return 0;
        }
    }

    private class PatchedContentRevision
    implements ContentRevision {
        private final FilePath myBeforeFilePath;
        private final FilePath myAfterFilePath;
        private String myContent;

        public PatchedContentRevision(FilePath beforeFilePath, FilePath afterFilePath) {
            this.myBeforeFilePath = beforeFilePath;
            this.myAfterFilePath = afterFilePath;
        }

        @Nullable
        public String getContent() throws VcsException {
            if (this.myContent == null) {
                try {
                    this.myContent = this.loadContent();
                }
                catch (Exception e) {
                    throw new VcsException((Throwable)e);
                }
            }
            return this.myContent;
        }

        @Nullable
        private String loadContent() throws IOException, PatchSyntaxException, ApplyPatchException {
            TextFilePatch patch = ShelvedChange.this.loadFilePatch();
            if (patch != null) {
                return this.loadContent(patch);
            }
            return null;
        }

        private String loadContent(TextFilePatch patch) throws ApplyPatchException {
            if (patch.isNewFile()) {
                return patch.getNewFileText();
            }
            if (patch.isDeletedFile()) {
                return null;
            }
            StringBuilder newText = new StringBuilder();
            ApplyFilePatchBase.applyModifications(patch, this.getBaseContent(), newText);
            return newText.toString();
        }

        private String getBaseContent() {
            this.myBeforeFilePath.refresh();
            Document doc = FileDocumentManager.getInstance().getDocument(this.myBeforeFilePath.getVirtualFile());
            return doc.getText();
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myAfterFilePath;
            if (filePath == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision.getFile must not return null");
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]));
            if (textRevisionNumber == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision.getRevisionNumber must not return null");
            }
            return textRevisionNumber;
        }
    }
}

