/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultPatchBaseVersionProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myVersionId;
    private final Pattern myRevisionPattern;
    private final AbstractVcs myVcs;

    public DefaultPatchBaseVersionProvider(Project project, VirtualFile file, String versionId) {
        String vcsPattern;
        this.myProject = project;
        this.myFile = file;
        this.myVersionId = versionId;
        this.myVcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(this.myFile);
        if (this.myVcs != null && (vcsPattern = this.myVcs.getRevisionPattern()) != null) {
            this.myRevisionPattern = Pattern.compile("\\(revision (" + vcsPattern + ")\\)");
            return;
        }
        this.myRevisionPattern = null;
    }

    public void getBaseVersionContent(final FilePath filePath, Processor<CharSequence> processor) throws VcsException {
        Matcher matcher;
        if (this.myVcs == null) {
            return;
        }
        final VcsHistoryProvider historyProvider = this.myVcs.getVcsHistoryProvider();
        if (historyProvider == null) {
            return;
        }
        VcsRevisionNumber revision = null;
        if (this.myRevisionPattern != null && (matcher = this.myRevisionPattern.matcher(this.myVersionId)).find()) {
            revision = this.myVcs.parseRevisionNumber(matcher.group(1), filePath);
        }
        Date versionDate = null;
        if (revision == null) {
            try {
                versionDate = new Date(this.myVersionId);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
        }
        try {
            final Ref ref = new Ref();
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    ref.set((Object)historyProvider.createSessionFor(filePath));
                }
            }, (String)VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), (boolean)true, (Project)this.myProject);
            if (ref.isNull()) {
                return;
            }
            VcsHistorySession session = (VcsHistorySession)ref.get();
            List list = session.getRevisionList();
            if (list == null) {
                return;
            }
            for (VcsFileRevision fileRevision : list) {
                boolean found;
                if (revision != null) {
                    found = fileRevision.getRevisionNumber().compareTo((Object)revision) <= 0;
                } else {
                    Date date = fileRevision.getRevisionDate();
                    boolean bl = found = date != null && date.before(versionDate);
                }
                if (!found) continue;
                fileRevision.loadContent();
                processor.process((Object)LoadTextUtil.getTextByBinaryPresentation(fileRevision.getContent(), this.myFile, false));
                break;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean canProvideContent() {
        if (this.myVcs == null) {
            return false;
        }
        if (this.myRevisionPattern != null && this.myRevisionPattern.matcher(this.myVersionId).matches()) {
            return true;
        }
        try {
            Date.parse(this.myVersionId);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }
}

