/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.CommonBundle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchCommitExecutor
implements CommitExecutor,
ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    public String PATCH_PATH = "";
    public boolean REVERSE_PATCH = false;

    public static CreatePatchCommitExecutor getInstance(Project project) {
        return (CreatePatchCommitExecutor)project.getComponent(CreatePatchCommitExecutor.class);
    }

    public CreatePatchCommitExecutor(Project project, ChangeListManager changeListManager) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
    }

    @Nls
    public String getActionText() {
        return VcsBundle.message((String)"create.patch.commit.action.text", (Object[])new Object[0]);
    }

    @NotNull
    public CommitSession createCommitSession() {
        CreatePatchCommitSession createPatchCommitSession = new CreatePatchCommitSession();
        if (createPatchCommitSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor.createCommitSession must not return null");
        }
        return createPatchCommitSession;
    }

    public void projectOpened() {
        this.myChangeListManager.registerCommitExecutor((CommitExecutor)this);
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CreatePatchCommitExecutor" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor.getComponentName must not return null");
        }
        return "CreatePatchCommitExecutor";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    private class CreatePatchCommitSession
    implements CommitSession {
        private final CreatePatchConfigurationPanel myPanel = new CreatePatchConfigurationPanel();

        private CreatePatchCommitSession() {
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI() {
            return this.myPanel.getPanel();
        }

        public JComponent getAdditionalConfigurationUI(Collection<Change> changes, String commitMessage) {
            if (CreatePatchCommitExecutor.this.PATCH_PATH.length() == 0) {
                CreatePatchCommitExecutor.this.PATCH_PATH = CreatePatchCommitExecutor.this.myProject.getBaseDir().getPresentableUrl();
            }
            this.myPanel.setFileName(ShelveChangesManager.suggestPatchName(commitMessage, new File(CreatePatchCommitExecutor.this.PATCH_PATH)));
            this.myPanel.setReversePatch(CreatePatchCommitExecutor.this.REVERSE_PATCH);
            return this.myPanel.getPanel();
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return this.myPanel.isOkToExecute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Collection<Change> changes, String commitMessage) {
            if (!this.myPanel.isOkToExecute()) {
                Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{this.myPanel.getError()}), (String)CommonBundle.getErrorTitle());
                return;
            }
            int binaryCount = 0;
            for (Change change : changes) {
                if (!ChangesUtil.isBinaryChange((Change)change)) continue;
                ++binaryCount;
            }
            if (binaryCount == changes.size()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showInfoMessage((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.all.binary", (Object[])new Object[0]), (String)VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]));
                    }
                });
                return;
            }
            try {
                String fileName = this.myPanel.getFileName();
                final File file = new File(fileName).getAbsoluteFile();
                CreatePatchCommitExecutor.this.PATCH_PATH = file.getParent();
                CreatePatchCommitExecutor.this.REVERSE_PATCH = this.myPanel.isReversePatch();
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(fileName));
                try {
                    List patches = TextPatchBuilder.buildPatch(changes, (String)CreatePatchCommitExecutor.this.myProject.getBaseDir().getPresentableUrl(), (boolean)CreatePatchCommitExecutor.this.REVERSE_PATCH);
                    String lineSeparator = CodeStyleFacade.getInstance((Project)CreatePatchCommitExecutor.this.myProject).getLineSeparator();
                    UnifiedDiffWriter.write((Collection)patches, (Writer)writer, (String)lineSeparator);
                }
                finally {
                    ((Writer)writer).close();
                }
                if (binaryCount == 0) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showInfoMessage((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.success.confirmation", (Object[])new Object[]{file.getPath()}), (String)VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]));
                        }
                    });
                } else {
                    final int binaryCount1 = binaryCount;
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showInfoMessage((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.partial.success.confirmation", (Object[])new Object[]{file.getPath(), binaryCount1}), (String)VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]));
                        }
                    });
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle());
                    }
                });
            }
        }

        public void executionCanceled() {
        }
    }
}

