/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;

public class IssueLinkRenderer {
    private final SimpleColoredComponent myColoredComponent;
    private final IssueNavigationConfiguration myIssueNavigationConfiguration;

    public IssueLinkRenderer(Project project, SimpleColoredComponent coloredComponent) {
        this.myIssueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
        this.myColoredComponent = coloredComponent;
    }

    public void appendTextWithLinks(String text) {
        this.appendTextWithLinks(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void appendTextWithLinks(String text, SimpleTextAttributes baseStyle) {
        List list = this.myIssueNavigationConfiguration.findIssueLinks(text);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            TextRange textRange = match.getRange();
            if (textRange.getStartOffset() > pos) {
                this.myColoredComponent.append(text.substring(pos, textRange.getStartOffset()), baseStyle);
            }
            this.myColoredComponent.append(textRange.substring(text), IssueLinkRenderer.getLinkAttributes(baseStyle), (Object)new TreeLinkMouseListener.BrowserLauncher(match.getTargetUrl()));
            pos = textRange.getEndOffset();
        }
        if (pos < text.length()) {
            this.myColoredComponent.append(text.substring(pos), baseStyle);
        }
    }

    private static SimpleTextAttributes getLinkAttributes(SimpleTextAttributes baseStyle) {
        return (baseStyle.getStyle() & 1) != 0 ? SimpleTextAttributes.LINK_BOLD_ATTRIBUTES : SimpleTextAttributes.LINK_ATTRIBUTES;
    }
}

