/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;

public class ChangelistConflictNotificationPanel
extends EditorNotificationPanel {
    private final ChangeList myChangeList;
    private final Change myChange;
    private final VirtualFile myFile;
    private ChangelistConflictTracker myTracker;

    public ChangelistConflictNotificationPanel(ChangelistConflictTracker tracker, VirtualFile file) {
        this.myTracker = tracker;
        this.myFile = file;
        final ChangeListManager manager = tracker.getChangeListManager();
        this.myChange = manager.getChange(file);
        this.myChangeList = manager.getChangeList(this.myChange);
        assert (this.myChangeList != null);
        this.myLabel.setText("File from non-active changelist is modified");
        this.createActionLabel("Move changes", new Runnable(){

            @Override
            public void run() {
                ChangelistConflictResolution.MOVE.resolveConflict(ChangelistConflictNotificationPanel.this.myTracker.getProject(), ChangelistConflictNotificationPanel.this.myChangeList.getChanges());
            }
        }).setToolTipText("Move changes to active changelist (" + manager.getDefaultChangeList().getName() + ")");
        this.createActionLabel("Switch changelist", new Runnable(){

            @Override
            public void run() {
                List<Change> changes = Collections.singletonList(ChangelistConflictNotificationPanel.this.myTracker.getChangeListManager().getChange(ChangelistConflictNotificationPanel.this.myFile));
                ChangelistConflictResolution.SWITCH.resolveConflict(ChangelistConflictNotificationPanel.this.myTracker.getProject(), changes);
            }
        }).setToolTipText("Set active changelist to '" + this.myChangeList.getName() + "'");
        this.createActionLabel("Ignore", new Runnable(){

            @Override
            public void run() {
                ChangelistConflictNotificationPanel.this.myTracker.ignoreConflict(ChangelistConflictNotificationPanel.this.myFile, true);
            }
        }).setToolTipText("Hide this notification");
        this.myLinksPanel.add((Component)new InplaceButton("Show options dialog", IconLoader.getIcon((String)"/general/ideOptions.png"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable(ChangelistConflictNotificationPanel.this.myTracker.getProject(), (Configurable)new ChangelistConflictConfigurable((ChangeListManagerImpl)manager));
            }
        }));
    }
}

