/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilteringStrategy
implements ChangeListFilteringStrategy {
    private final CopyOnWriteArrayList<ChangeListener> myListeners = ContainerUtil.createEmptyCOWList();
    private MyUI myUI;
    private final Project myProject;
    private final List<FilePath> mySelection = new ArrayList<FilePath>();

    public StructureFilteringStrategy(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return VcsBundle.message((String)"filter.structure.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent getFilterUI() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI.getComponent();
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        this.myUI.reset();
        this.myUI.append(changeLists);
    }

    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void resetFilterBase() {
        this.myUI.reset();
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        this.myUI.append(changeLists);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        List<CommittedChangeList> list;
        if (this.mySelection.size() == 0) {
            list = changeLists;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy.filterChangeLists must not return null");
            return list;
        }
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        for (CommittedChangeList list2 : changeLists) {
            if (!this.listMatchesSelection(list2)) continue;
            result.add(list2);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy.filterChangeLists must not return null");
    }

    private boolean listMatchesSelection(CommittedChangeList list) {
        for (Change change : list.getChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            for (FilePath selPath : this.mySelection) {
                if (!path.isUnder(selPath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private class MyUI {
        private final JComponent myScrollPane;
        private final Tree myStructureTree = new Tree();
        private boolean myRendererInitialized;
        private final TreeModelBuilder myBuilder;
        private TreeState myState;

        public MyUI() {
            this.myStructureTree.setRootVisible(false);
            this.myStructureTree.setShowsRootHandles(true);
            this.myStructureTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    StructureFilteringStrategy.this.mySelection.clear();
                    ChangesBrowserNode node = (ChangesBrowserNode)e.getPath().getLastPathComponent();
                    Collections.addAll(StructureFilteringStrategy.this.mySelection, node.getFilePathsUnder());
                    for (ChangeListener listener : StructureFilteringStrategy.this.myListeners) {
                        listener.stateChanged(new ChangeEvent(this));
                    }
                }
            });
            this.myScrollPane = new JScrollPane((Component)this.myStructureTree);
            this.myBuilder = new TreeModelBuilder(StructureFilteringStrategy.this.myProject, false);
        }

        public void initRenderer() {
            if (!this.myRendererInitialized) {
                this.myRendererInitialized = true;
                this.myStructureTree.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(StructureFilteringStrategy.this.myProject, false, false)));
            }
        }

        public JComponent getComponent() {
            return this.myScrollPane;
        }

        public void reset() {
            this.myState = TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            this.myStructureTree.setModel((TreeModel)this.myBuilder.clearAndGetModel());
        }

        public void append(List<CommittedChangeList> changeLists) {
            TreeState localState = this.myState != null && this.myBuilder.isEmpty() ? this.myState : TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            HashSet<FilePath> filePaths = new HashSet<FilePath>();
            for (CommittedChangeList changeList : changeLists) {
                for (Change change : changeList.getChanges()) {
                    FilePath path = ChangesUtil.getFilePath((Change)change);
                    if (path.getParentPath() == null) continue;
                    filePaths.add(path.getParentPath());
                }
            }
            DefaultTreeModel model = this.myBuilder.buildModelFromFilePaths(filePaths);
            this.myStructureTree.setModel((TreeModel)model);
            localState.applyTo((JTree)this.myStructureTree, (DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot());
            this.myStructureTree.revalidate();
            this.myStructureTree.repaint();
            this.initRenderer();
        }
    }
}

