/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public abstract class LabeledComboBoxAction
extends AnAction
implements CustomComponentAction {
    private final JLabel myLabel;
    private JPanel myPanel;
    private final JComboBox myComboBox;

    protected LabeledComboBoxAction(String label) {
        String labelString = label;
        this.myComboBox = new JComboBox();
        this.myLabel = new JLabel(labelString);
    }

    public void actionPerformed(AnActionEvent e) {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.myPanel.add((Component)this.myLabel, "West");
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabeledComboBoxAction.this.selectionChanged(LabeledComboBoxAction.this.myComboBox.getSelectedItem());
                }
            });
            this.myComboBox.setModel(this.createModel());
            this.myPanel.add((Component)this.myComboBox, "Center");
        }
        return this.myPanel;
    }

    protected void setModel(ComboBoxModel model) {
        this.myComboBox.setModel(model);
    }

    protected void enableSelf(boolean enable) {
        this.myComboBox.setEnabled(enable);
        this.myLabel.setEnabled(enable);
    }

    protected boolean isEnabled() {
        return this.myComboBox.isEnabled();
    }

    protected Object getSelected() {
        return this.myComboBox.getSelectedItem();
    }

    protected ComboBoxModel getModel() {
        return this.myComboBox.getModel();
    }

    protected void setRenderer(ListCellRenderer renderer) {
        this.myComboBox.setRenderer(renderer);
    }

    protected abstract void selectionChanged(Object var1);

    protected abstract ComboBoxModel createModel();

    public void setSelected(int idx) {
        ComboBoxModel boxModel = this.getModel();
        if (boxModel.getSize() > 0) {
            boxModel.setSelectedItem(boxModel.getElementAt(idx));
        }
    }
}

