/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CompositeChangeListFilteringStrategy
implements ChangeListFilteringStrategy {
    private final Map<String, ChangeListFilteringStrategy> myDelegates = new HashMap<String, ChangeListFilteringStrategy>();

    public JComponent getFilterUI() {
        return null;
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.setFilterBase(changeLists);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.addChangeListener(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.removeChangeListener(listener);
        }
    }

    public void resetFilterBase() {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.resetFilterBase();
        }
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.appendFilterBase(changeLists);
        }
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        List<Object> result = new ArrayList<CommittedChangeList>(changeLists);
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            result = delegate.filterChangeLists(result);
        }
        ArrayList<CommittedChangeList> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/CompositeChangeListFilteringStrategy.filterChangeLists must not return null");
        }
        return arrayList;
    }

    public void addStrategy(String key, ChangeListFilteringStrategy strategy) {
        this.myDelegates.put(key, strategy);
    }

    public ChangeListFilteringStrategy removeStrategy(String key) {
        return this.myDelegates.remove(key);
    }
}

