/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.IncomingChangeState;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ChangesCacheFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.ChangesCacheFile");
    private static final int VERSION = 6;
    private final File myPath;
    private final File myIndexPath;
    private RandomAccessFile myStream;
    private RandomAccessFile myIndexStream;
    private boolean myStreamsOpen;
    private final Project myProject;
    private final AbstractVcs myVcs;
    private final CachingCommittedChangesProvider myChangesProvider;
    private final ProjectLevelVcsManager myVcsManager;
    private final FilePath myRootPath;
    private final RepositoryLocation myLocation;
    private Date myFirstCachedDate;
    private Date myLastCachedDate;
    private long myFirstCachedChangelist = Long.MAX_VALUE;
    private long myLastCachedChangelist = -1L;
    private int myIncomingCount = 0;
    private boolean myHaveCompleteHistory = false;
    private boolean myHeaderLoaded = false;
    @NonNls
    private static final String INDEX_EXTENSION = ".index";
    private static final int INDEX_ENTRY_SIZE = 26;
    private static final int HEADER_SIZE = 46;
    private static final IndexEntry[] NO_ENTRIES = new IndexEntry[0];

    public ChangesCacheFile(Project project, File path, AbstractVcs vcs, VirtualFile root, RepositoryLocation location) {
        Calendar date = Calendar.getInstance();
        date.set(2020, 1, 2);
        this.myFirstCachedDate = date.getTime();
        date.set(1970, 1, 2);
        this.myLastCachedDate = date.getTime();
        this.myProject = project;
        this.myPath = path;
        this.myIndexPath = new File(this.myPath.toString() + INDEX_EXTENSION);
        this.myVcs = vcs;
        this.myChangesProvider = (CachingCommittedChangesProvider)vcs.getCommittedChangesProvider();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myRootPath = new FilePathImpl(root);
        this.myLocation = location;
    }

    public RepositoryLocation getLocation() {
        return this.myLocation;
    }

    public CachingCommittedChangesProvider getProvider() {
        return this.myChangesProvider;
    }

    public boolean isEmpty() throws IOException {
        if (!this.myPath.exists()) {
            return true;
        }
        try {
            this.loadHeader();
        }
        catch (VersionMismatchException ex) {
            this.myPath.delete();
            this.myIndexPath.delete();
            return true;
        }
        catch (EOFException ex) {
            this.myPath.delete();
            this.myIndexPath.delete();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> writeChanges(List<CommittedChangeList> changes) throws IOException {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>(changes.size());
        boolean wasEmpty = this.isEmpty();
        this.openStreams();
        try {
            if (wasEmpty) {
                this.myHeaderLoaded = true;
                this.writeHeader();
            }
            this.myStream.seek(this.myStream.length());
            IndexEntry[] entries = this.readLastIndexEntries(0, changes.size());
            Collections.sort(changes, new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return Comparing.compare((Comparable)o1.getCommitDate(), (Comparable)o2.getCommitDate());
                }
            });
            for (CommittedChangeList list : changes) {
                boolean duplicate = false;
                for (IndexEntry entry : entries) {
                    if (list.getCommitDate().getTime() != entry.date || list.getNumber() != entry.number) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    ChangesCacheFile.debug("Skipping duplicate changelist " + list.getNumber());
                    continue;
                }
                ChangesCacheFile.debug("Writing incoming changelist " + list.getNumber());
                result.add(list);
                long position = this.myStream.getFilePointer();
                this.myChangesProvider.writeChangeList((DataOutput)this.myStream, list);
                this.updateCachedRange(list);
                this.writeIndexEntry(list.getNumber(), list.getCommitDate().getTime(), position, false);
                ++this.myIncomingCount;
            }
            this.writeHeader();
            this.myHeaderLoaded = true;
        }
        finally {
            this.closeStreams();
        }
        return result;
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private void updateCachedRange(CommittedChangeList list) {
        if (list.getCommitDate().getTime() > this.myLastCachedDate.getTime()) {
            this.myLastCachedDate = list.getCommitDate();
        }
        if (list.getCommitDate().getTime() < this.myFirstCachedDate.getTime()) {
            this.myFirstCachedDate = list.getCommitDate();
        }
        if (list.getNumber() < this.myFirstCachedChangelist) {
            this.myFirstCachedChangelist = list.getNumber();
        }
        if (list.getNumber() > this.myLastCachedChangelist) {
            this.myLastCachedChangelist = list.getNumber();
        }
    }

    private void writeIndexEntry(long number, long date, long offset, boolean completelyDownloaded) throws IOException {
        this.myIndexStream.writeLong(number);
        this.myIndexStream.writeLong(date);
        this.myIndexStream.writeLong(offset);
        this.myIndexStream.writeShort(completelyDownloaded ? 1 : 0);
    }

    private void openStreams() throws FileNotFoundException {
        this.myStream = new RandomAccessFile(this.myPath, "rw");
        this.myIndexStream = new RandomAccessFile(this.myIndexPath, "rw");
        this.myStreamsOpen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStreams() throws IOException {
        this.myStreamsOpen = false;
        try {
            this.myStream.close();
        }
        finally {
            this.myIndexStream.close();
        }
    }

    private void writeHeader() throws IOException {
        assert (this.myStreamsOpen && this.myHeaderLoaded);
        this.myStream.seek(0L);
        this.myStream.writeInt(6);
        this.myStream.writeInt(this.myChangesProvider.getFormatVersion());
        this.myStream.writeLong(this.myLastCachedDate.getTime());
        this.myStream.writeLong(this.myFirstCachedDate.getTime());
        this.myStream.writeLong(this.myFirstCachedChangelist);
        this.myStream.writeLong(this.myLastCachedChangelist);
        this.myStream.writeShort(this.myHaveCompleteHistory ? 1 : 0);
        this.myStream.writeInt(this.myIncomingCount);
        ChangesCacheFile.debug("Saved header for cache of " + this.myLocation + ": last cached date=" + this.myLastCachedDate + ", last cached number=" + this.myLastCachedChangelist + ", incoming count=" + this.myIncomingCount);
    }

    private IndexEntry[] readIndexEntriesByOffset(long offsetFromStart, int count) throws IOException {
        if (!this.myIndexPath.exists()) {
            return NO_ENTRIES;
        }
        long totalCount = this.myIndexStream.length() / 26L;
        if ((long)count > totalCount - offsetFromStart) {
            count = (int)(totalCount - offsetFromStart);
        }
        if (count == 0) {
            return NO_ENTRIES;
        }
        this.myIndexStream.seek(26L * offsetFromStart);
        IndexEntry[] result = new IndexEntry[count];
        for (int i = count - 1; i >= 0; --i) {
            result[i] = new IndexEntry();
            this.readIndexEntry(result[i]);
        }
        return result;
    }

    private IndexEntry[] readLastIndexEntries(int offset, int count) throws IOException {
        if (!this.myIndexPath.exists()) {
            return NO_ENTRIES;
        }
        long totalCount = this.myIndexStream.length() / 26L;
        if ((long)count > totalCount - (long)offset) {
            count = (int)totalCount - offset;
        }
        if (count == 0) {
            return NO_ENTRIES;
        }
        this.myIndexStream.seek(this.myIndexStream.length() - (long)(26 * (count + offset)));
        IndexEntry[] result = new IndexEntry[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new IndexEntry();
            this.readIndexEntry(result[i]);
        }
        return result;
    }

    private void readIndexEntry(IndexEntry result) throws IOException {
        result.number = this.myIndexStream.readLong();
        result.date = this.myIndexStream.readLong();
        result.offset = this.myIndexStream.readLong();
        result.completelyDownloaded = this.myIndexStream.readShort() != 0;
    }

    public Date getLastCachedDate() throws IOException {
        this.loadHeader();
        return this.myLastCachedDate;
    }

    public Date getFirstCachedDate() throws IOException {
        this.loadHeader();
        return this.myFirstCachedDate;
    }

    public long getFirstCachedChangelist() throws IOException {
        this.loadHeader();
        return this.myFirstCachedChangelist;
    }

    public long getLastCachedChangelist() throws IOException {
        this.loadHeader();
        return this.myLastCachedChangelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() throws IOException {
        if (!this.myHeaderLoaded) {
            RandomAccessFile stream = new RandomAccessFile(this.myPath, "r");
            try {
                int version = stream.readInt();
                if (version != 6) {
                    throw new VersionMismatchException();
                }
                int providerVersion = stream.readInt();
                if (providerVersion != this.myChangesProvider.getFormatVersion()) {
                    throw new VersionMismatchException();
                }
                this.myLastCachedDate = new Date(stream.readLong());
                this.myFirstCachedDate = new Date(stream.readLong());
                this.myFirstCachedChangelist = stream.readLong();
                this.myLastCachedChangelist = stream.readLong();
                this.myHaveCompleteHistory = stream.readShort() != 0;
                this.myIncomingCount = stream.readInt();
                assert (stream.getFilePointer() == 46L);
            }
            finally {
                stream.close();
            }
            this.myHeaderLoaded = true;
        }
    }

    public Iterator<ChangesBunch> getBackBunchedIterator(int bunchSize) {
        return new BackIterator(bunchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CommittedChangeList> readChangesInterval(long indexOffset, int number) throws IOException {
        this.openStreams();
        try {
            IndexEntry[] entries = this.readIndexEntriesByOffset(indexOffset, number);
            if (entries.length == 0) {
                List<CommittedChangeList> list = Collections.emptyList();
                return list;
            }
            ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
            for (IndexEntry entry : entries) {
                CommittedChangeList changeList = this.loadChangeListAt(entry.offset);
                result.add(changeList);
            }
            ArrayList<CommittedChangeList> arrayList = result;
            return arrayList;
        }
        finally {
            this.closeStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> readChanges(ChangeBrowserSettings settings, int maxCount) throws IOException {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        ChangeBrowserSettings.Filter filter = settings.createFilter();
        this.openStreams();
        try {
            if (maxCount == 0) {
                this.myStream.seek(46L);
                while (this.myStream.getFilePointer() < this.myStream.length()) {
                    CommittedChangeList changeList = this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream);
                    if (!filter.accepts(changeList)) continue;
                    result.add(changeList);
                }
            } else if (!settings.isAnyFilterSpecified()) {
                IndexEntry[] entries;
                for (IndexEntry entry : entries = this.readLastIndexEntries(0, maxCount)) {
                    this.myStream.seek(entry.offset);
                    result.add(this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream));
                }
            } else {
                IndexEntry[] entries;
                int offset = 0;
                while (result.size() < maxCount && (entries = this.readLastIndexEntries(offset, 1)).length != 0) {
                    CommittedChangeList changeList = this.loadChangeListAt(entries[0].offset);
                    if (filter.accepts(changeList)) {
                        result.add(0, changeList);
                    }
                    ++offset;
                }
            }
            ArrayList<CommittedChangeList> arrayList = result;
            return arrayList;
        }
        finally {
            this.closeStreams();
        }
    }

    public boolean hasCompleteHistory() {
        return this.myHaveCompleteHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHaveCompleteHistory(boolean haveCompleteHistory) {
        if (this.myHaveCompleteHistory != haveCompleteHistory) {
            this.myHaveCompleteHistory = haveCompleteHistory;
            try {
                this.openStreams();
                try {
                    this.writeHeader();
                }
                finally {
                    this.closeStreams();
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> loadIncomingChanges() throws IOException {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        int offset = 0;
        this.openStreams();
        try {
            IndexEntry[] entries;
            while ((entries = this.readLastIndexEntries(offset, 1)).length != 0) {
                if (!entries[0].completelyDownloaded) {
                    IncomingChangeListData data = this.readIncomingChangeListData(offset, entries[0]);
                    if (data.accountedChanges.size() == 0) {
                        result.add(data.changeList);
                    } else {
                        ReceivedChangeList changeList = new ReceivedChangeList(data.changeList);
                        for (Change change : data.changeList.getChanges()) {
                            if (data.accountedChanges.contains(change)) continue;
                            changeList.addChange(change);
                        }
                        result.add((CommittedChangeList)changeList);
                    }
                    if (result.size() == this.myIncomingCount) break;
                }
                ++offset;
            }
            ChangesCacheFile.debug("Loaded " + result.size() + " incoming changelists");
        }
        finally {
            this.closeStreams();
        }
        return result;
    }

    private CommittedChangeList loadChangeListAt(long clOffset) throws IOException {
        this.myStream.seek(clOffset);
        return this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUpdatedFiles(UpdatedFiles updatedFiles, Collection<CommittedChangeList> receivedChanges) throws IOException {
        boolean haveUnaccountedUpdatedFiles = false;
        this.openStreams();
        this.loadHeader();
        ReceivedChangeListTracker tracker = new ReceivedChangeListTracker();
        try {
            List<IncomingChangeListData> incomingData = this.loadIncomingChangeListData();
            for (FileGroup group : updatedFiles.getTopLevelGroups()) {
                haveUnaccountedUpdatedFiles |= this.processGroup(group, incomingData, tracker);
            }
            if (!haveUnaccountedUpdatedFiles) {
                for (IncomingChangeListData data : incomingData) {
                    this.saveIncoming(data);
                }
                this.writeHeader();
            }
        }
        finally {
            this.closeStreams();
        }
        receivedChanges.addAll(tracker.getChangeLists());
        return haveUnaccountedUpdatedFiles;
    }

    private void saveIncoming(IncomingChangeListData data) throws IOException {
        this.writePartial(data);
        if (data.accountedChanges.size() == data.changeList.getChanges().size()) {
            ChangesCacheFile.debug("Removing changelist " + data.changeList.getNumber() + " from incoming changelists");
            this.myIndexStream.seek(data.indexOffset);
            this.writeIndexEntry(data.indexEntry.number, data.indexEntry.date, data.indexEntry.offset, true);
            --this.myIncomingCount;
        }
    }

    private boolean processGroup(FileGroup group, List<IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean haveUnaccountedUpdatedFiles = false;
        List list = group.getFilesAndRevisions(this.myVcsManager);
        for (Pair pair : list) {
            String file = (String)pair.first;
            FilePathImpl path = new FilePathImpl(new File(file), false);
            if (!path.isUnder(this.myRootPath, false) || pair.second == null) continue;
            if (group.getId().equals("REMOVED_FROM_REPOSITORY")) {
                haveUnaccountedUpdatedFiles |= ChangesCacheFile.processDeletedFile(path, incomingData, tracker);
                continue;
            }
            haveUnaccountedUpdatedFiles |= ChangesCacheFile.processFile(path, (VcsRevisionNumber)pair.second, incomingData, tracker);
        }
        for (FileGroup childGroup : group.getChildren()) {
            haveUnaccountedUpdatedFiles |= this.processGroup(childGroup, incomingData, tracker);
        }
        return haveUnaccountedUpdatedFiles;
    }

    private static boolean processFile(FilePath path, VcsRevisionNumber number, List<IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean foundRevision = false;
        ChangesCacheFile.debug("Processing updated file " + path + ", revision " + number);
        for (IncomingChangeListData data : incomingData) {
            for (Change change : data.changeList.getChanges()) {
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision == null || !afterRevision.getFile().equals(path)) continue;
                int rc = number.compareTo((Object)afterRevision.getRevisionNumber());
                if (rc == 0) {
                    foundRevision = true;
                }
                if (rc < 0) continue;
                tracker.addChange(data.changeList, change);
                data.accountedChanges.add(change);
            }
        }
        ChangesCacheFile.debug(foundRevision ? "All changes for file found" : "Some of changes for file not found");
        return !foundRevision;
    }

    private static boolean processDeletedFile(FilePath path, List<IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean foundRevision = false;
        for (IncomingChangeListData data : incomingData) {
            for (Change change : data.changeList.getChanges()) {
                ContentRevision beforeRevision = change.getBeforeRevision();
                if (beforeRevision == null || !beforeRevision.getFile().equals(path)) continue;
                tracker.addChange(data.changeList, change);
                data.accountedChanges.add(change);
                if (change.getAfterRevision() != null) continue;
                foundRevision = true;
            }
        }
        return !foundRevision;
    }

    private List<IncomingChangeListData> loadIncomingChangeListData() throws IOException {
        long length = this.myIndexStream.length();
        long totalCount = length / 26L;
        ArrayList<IncomingChangeListData> incomingData = new ArrayList<IncomingChangeListData>();
        int i = 0;
        while ((long)i < totalCount) {
            long indexOffset = length - (long)((i + 1) * 26);
            this.myIndexStream.seek(indexOffset);
            IndexEntry e = new IndexEntry();
            this.readIndexEntry(e);
            if (!e.completelyDownloaded) {
                incomingData.add(this.readIncomingChangeListData(indexOffset, e));
                if (incomingData.size() == this.myIncomingCount) break;
            }
            ++i;
        }
        ChangesCacheFile.debug("Loaded " + incomingData.size() + " incoming changelist pointers");
        return incomingData;
    }

    private IncomingChangeListData readIncomingChangeListData(long indexOffset, IndexEntry e) throws IOException {
        IncomingChangeListData data = new IncomingChangeListData();
        data.indexOffset = indexOffset;
        data.indexEntry = e;
        data.changeList = this.loadChangeListAt(e.offset);
        this.readPartial(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePartial(IncomingChangeListData data) throws IOException {
        File partialFile = this.getPartialPath(data.indexEntry.offset);
        int accounted = data.accountedChanges.size();
        if (accounted == data.changeList.getChanges().size()) {
            partialFile.delete();
        } else if (accounted > 0) {
            RandomAccessFile file = new RandomAccessFile(partialFile, "rw");
            try {
                file.writeInt(accounted);
                for (Change c : data.accountedChanges) {
                    boolean isAfterRevision = true;
                    ContentRevision revision = c.getAfterRevision();
                    if (revision == null) {
                        isAfterRevision = false;
                        revision = c.getBeforeRevision();
                        assert (revision != null);
                    }
                    file.writeByte(isAfterRevision ? 1 : 0);
                    file.writeUTF(revision.getFile().getIOFile().toString());
                }
            }
            finally {
                file.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartial(IncomingChangeListData data) {
        HashSet<Change> result;
        block7: {
            result = new HashSet<Change>();
            try {
                File partialFile = this.getPartialPath(data.indexEntry.offset);
                if (!partialFile.exists()) break block7;
                RandomAccessFile file = new RandomAccessFile(partialFile, "r");
                try {
                    int count = file.readInt();
                    for (int i = 0; i < count; ++i) {
                        boolean isAfterRevision = file.readByte() != 0;
                        String path = file.readUTF();
                        for (Change c : data.changeList.getChanges()) {
                            ContentRevision afterRevision = isAfterRevision ? c.getAfterRevision() : c.getBeforeRevision();
                            if (afterRevision == null || !afterRevision.getFile().getIOFile().toString().equals(path)) continue;
                            result.add(c);
                        }
                    }
                }
                finally {
                    file.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
        data.accountedChanges = result;
    }

    @NonNls
    private File getPartialPath(long offset) {
        return new File(this.myPath + "." + offset + ".partial");
    }

    public boolean refreshIncomingChanges() throws IOException, VcsException {
        return new RefreshIncomingChangesOperation().invoke();
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public FilePath getRootPath() {
        return this.myRootPath;
    }

    private static class ReceivedChangeListTracker {
        private final Map<CommittedChangeList, ReceivedChangeList> myMap = new HashMap<CommittedChangeList, ReceivedChangeList>();

        private ReceivedChangeListTracker() {
        }

        public void addChange(CommittedChangeList changeList, Change change) {
            ReceivedChangeList list = this.myMap.get(changeList);
            if (list == null) {
                list = new ReceivedChangeList(changeList);
                this.myMap.put(changeList, list);
            }
            list.addChange(change);
        }

        public Collection<? extends CommittedChangeList> getChangeLists() {
            return this.myMap.values();
        }
    }

    private static class VersionMismatchException
    extends RuntimeException {
        private VersionMismatchException() {
        }
    }

    private static class IncomingChangeListData {
        public long indexOffset;
        public IndexEntry indexEntry;
        public CommittedChangeList changeList;
        public Set<Change> accountedChanges;

        private IncomingChangeListData() {
        }
    }

    private static class IndexEntry {
        long number;
        long date;
        long offset;
        boolean completelyDownloaded;

        private IndexEntry() {
        }
    }

    private class RefreshIncomingChangesOperation {
        private FactoryMap<VirtualFile, VcsRevisionNumber> myCurrentRevisions;
        private Set<FilePath> myDeletedFiles;
        private Set<FilePath> myCreatedFiles;
        private Set<FilePath> myReplacedFiles;
        private final Map<Long, IndexEntry> myIndexEntryCache = new HashMap<Long, IndexEntry>();
        private final Map<Long, CommittedChangeList> myPreviousChangeListsCache = new HashMap<Long, CommittedChangeList>();
        private List<LocalChangeList> myChangeLists;
        private ChangeListManagerImpl myClManager;

        private RefreshIncomingChangesOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() throws VcsException, IOException {
            if (ChangesCacheFile.this.myProject.isDisposed()) {
                return false;
            }
            this.myClManager = ChangeListManagerImpl.getInstanceImpl(ChangesCacheFile.this.myProject);
            final DiffProvider diffProvider = ChangesCacheFile.this.myVcs.getDiffProvider();
            if (diffProvider == null) {
                return false;
            }
            ChangesCacheFile.this.myLocation.onBeforeBatch();
            Collection incomingFiles = ChangesCacheFile.this.myChangesProvider.getIncomingFiles(ChangesCacheFile.this.myLocation);
            boolean anyChanges = false;
            ChangesCacheFile.this.openStreams();
            ChangesCacheFile.this.loadHeader();
            this.myCurrentRevisions = new FactoryMap<VirtualFile, VcsRevisionNumber>(){

                protected VcsRevisionNumber create(VirtualFile key) {
                    return diffProvider.getCurrentRevision(key);
                }
            };
            try {
                List list = ChangesCacheFile.this.loadIncomingChangeListData();
                this.myDeletedFiles = new HashSet<FilePath>();
                this.myCreatedFiles = new HashSet<FilePath>();
                this.myReplacedFiles = new HashSet<FilePath>();
                IncomingChangeState.header(ChangesCacheFile.this.myLocation.toPresentableString());
                for (IncomingChangeListData data : list) {
                    ChangesCacheFile.debug("Checking incoming changelist " + data.changeList.getNumber());
                    boolean updated = false;
                    for (Change change : data.changeList.getChanges()) {
                        if (data.accountedChanges.contains(change)) continue;
                        ContentRevision revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                        IncomingChangeState state = new IncomingChangeState(change, revision.getRevisionNumber().asString());
                        boolean changeFound = this.processIncomingChange(change, data, incomingFiles, state);
                        state.logSelf();
                        if (changeFound) {
                            data.accountedChanges.add(change);
                        }
                        updated |= changeFound;
                    }
                    if (!updated) continue;
                    anyChanges = true;
                    ChangesCacheFile.this.saveIncoming(data);
                }
                IncomingChangeState.footer();
                if (anyChanges) {
                    ChangesCacheFile.this.writeHeader();
                }
            }
            finally {
                ChangesCacheFile.this.myLocation.onAfterBatch();
                ChangesCacheFile.this.closeStreams();
            }
            return anyChanges;
        }

        private boolean processIncomingChange(Change change, IncomingChangeListData changeListData, @Nullable Collection<FilePath> incomingFiles, IncomingChangeState state) throws IOException {
            CommittedChangeList changeList = changeListData.changeList;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision != null) {
                if (afterRevision.getFile().isNonLocal()) {
                    state.setState(IncomingChangeState.State.AFTER_DOES_NOT_MATTER_NON_LOCAL);
                    return true;
                }
                if (change.getBeforeRevision() == null) {
                    FilePath path = afterRevision.getFile();
                    ChangesCacheFile.debug("Marking created file " + path);
                    this.myCreatedFiles.add(path);
                } else if (change.getBeforeRevision().getFile().getIOFile().getAbsolutePath().equals(afterRevision.getFile().getIOFile().getAbsolutePath()) && change.isIsReplaced()) {
                    this.myReplacedFiles.add(afterRevision.getFile());
                }
                if (incomingFiles != null && !incomingFiles.contains(afterRevision.getFile())) {
                    ChangesCacheFile.debug("Skipping new/changed file outside of incoming files: " + afterRevision.getFile());
                    state.setState(IncomingChangeState.State.AFTER_DOES_NOT_MATTER_OUTSIDE_INCOMING);
                    return true;
                }
                ChangesCacheFile.debug("Checking file " + afterRevision.getFile().getPath());
                FilePath localPath = ChangesUtil.getLocalPath((Project)ChangesCacheFile.this.myProject, (FilePath)afterRevision.getFile());
                if (!FileUtil.isAncestor((File)ChangesCacheFile.this.myRootPath.getIOFile(), (File)localPath.getIOFile(), (boolean)false)) {
                    ChangesCacheFile.debug("Alien path " + localPath.getPresentableUrl() + " under root " + ChangesCacheFile.this.myRootPath.getPresentableUrl() + "; skipping.");
                    state.setState(IncomingChangeState.State.AFTER_DOES_NOT_MATTER_ALIEN_PATH);
                    return true;
                }
                localPath.refresh();
                VirtualFile file = localPath.getVirtualFile();
                if (this.isDeletedFile(this.myDeletedFiles, afterRevision, this.myReplacedFiles)) {
                    ChangesCacheFile.debug("Found deleted file");
                    state.setState(IncomingChangeState.State.AFTER_DOES_NOT_MATTER_DELETED_FOUND_IN_INCOMING_LIST);
                    return true;
                }
                if (file != null) {
                    VcsRevisionNumber revision = (VcsRevisionNumber)this.myCurrentRevisions.get((Object)file);
                    if (revision != null) {
                        ChangesCacheFile.debug("Current revision is " + revision + ", changelist revision is " + afterRevision.getRevisionNumber());
                        if (ChangesCacheFile.this.myChangesProvider.isChangeLocallyAvailable(afterRevision.getFile(), revision, afterRevision.getRevisionNumber(), changeList)) {
                            state.setState(IncomingChangeState.State.AFTER_EXISTS_LOCALLY_AVAILABLE);
                            return true;
                        }
                        state.setState(IncomingChangeState.State.AFTER_EXISTS_NOT_LOCALLY_AVAILABLE);
                        return false;
                    }
                    ChangesCacheFile.debug("Failed to fetch revision");
                    state.setState(IncomingChangeState.State.AFTER_EXISTS_REVISION_NOT_LOADED);
                    return false;
                }
                if (ChangesCacheFile.this.myChangesProvider.isChangeLocallyAvailable(afterRevision.getFile(), null, afterRevision.getRevisionNumber(), changeList)) {
                    state.setState(IncomingChangeState.State.AFTER_NOT_EXISTS_LOCALLY_AVAILABLE);
                    return true;
                }
                if (this.fileMarkedForDeletion(localPath)) {
                    ChangesCacheFile.debug("File marked for deletion and not committed jet.");
                    state.setState(IncomingChangeState.State.AFTER_NOT_EXISTS_MARKED_FOR_DELETION);
                    return true;
                }
                if (this.wasSubsequentlyDeleted(afterRevision.getFile(), changeListData.indexOffset)) {
                    state.setState(IncomingChangeState.State.AFTER_NOT_EXISTS_SUBSEQUENTLY_DELETED);
                    return true;
                }
                ChangesCacheFile.debug("Could not find local file for change " + afterRevision.getFile().getPath());
                state.setState(IncomingChangeState.State.AFTER_NOT_EXISTS_OTHER);
                return false;
            }
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null);
            ChangesCacheFile.debug("Checking deleted file " + beforeRevision.getFile());
            this.myDeletedFiles.add(beforeRevision.getFile());
            if (incomingFiles != null && !incomingFiles.contains(beforeRevision.getFile())) {
                ChangesCacheFile.debug("Skipping deleted file outside of incoming files: " + beforeRevision.getFile());
                state.setState(IncomingChangeState.State.BEFORE_DOES_NOT_MATTER_OUTSIDE);
                return true;
            }
            beforeRevision.getFile().refresh();
            if (beforeRevision.getFile().getVirtualFile() == null || this.myCreatedFiles.contains(beforeRevision.getFile())) {
                boolean locallyDeleted = this.myClManager.isContainedInLocallyDeleted(beforeRevision.getFile());
                ChangesCacheFile.debug(locallyDeleted ? "File deleted locally, change marked as incoming" : "File already deleted");
                state.setState(locallyDeleted ? IncomingChangeState.State.BEFORE_NOT_EXISTS_DELETED_LOCALLY : IncomingChangeState.State.BEFORE_NOT_EXISTS_ALREADY_DELETED);
                return !locallyDeleted;
            }
            if (!ChangesCacheFile.this.myVcs.fileExistsInVcs(beforeRevision.getFile())) {
                ChangesCacheFile.debug("File exists locally and is unversioned");
                state.setState(IncomingChangeState.State.BEFORE_UNVERSIONED_INSTEAD_OF_VERS_DELETED);
                return true;
            }
            VirtualFile file = beforeRevision.getFile().getVirtualFile();
            VcsRevisionNumber currentRevision = (VcsRevisionNumber)this.myCurrentRevisions.get((Object)file);
            if (currentRevision != null && currentRevision.compareTo((Object)beforeRevision.getRevisionNumber()) > 0) {
                ChangesCacheFile.debug("File with same name was added after file deletion");
                state.setState(IncomingChangeState.State.BEFORE_SAME_NAME_ADDED_AFTER_DELETION);
                return true;
            }
            state.setState(IncomingChangeState.State.BEFORE_EXISTS_BUT_SHOULD_NOT);
            ChangesCacheFile.debug("File exists locally and no 'create' change found for it");
            return false;
        }

        private boolean fileMarkedForDeletion(FilePath localPath) {
            List<LocalChangeList> changeLists = this.myClManager.getChangeListsCopy();
            for (LocalChangeList list : changeLists) {
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    if (change.getBeforeRevision() == null || change.getBeforeRevision().getFile() == null || !change.getBeforeRevision().getFile().getPath().equals(localPath.getPath()) || !FileStatus.DELETED.equals(change.getFileStatus()) && !change.isMoved() && !change.isRenamed()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean wasSubsequentlyDeleted(FilePath file, long indexOffset) {
            try {
                indexOffset += 26L;
                while (indexOffset < ChangesCacheFile.this.myIndexStream.length()) {
                    IndexEntry e = this.getIndexEntryAtOffset(indexOffset);
                    CommittedChangeList changeList = this.getChangeListAtOffset(e.offset);
                    for (Change c : changeList.getChanges()) {
                        ContentRevision beforeRevision = c.getBeforeRevision();
                        if (beforeRevision != null && c.getAfterRevision() == null) {
                            if (!file.getIOFile().getAbsolutePath().equals(beforeRevision.getFile().getIOFile().getAbsolutePath()) && !file.isUnder(beforeRevision.getFile(), false)) continue;
                            ChangesCacheFile.debug("Found subsequent deletion for file " + file);
                            return true;
                        }
                        if (beforeRevision == null || c.getAfterRevision() == null || !beforeRevision.getFile().getIOFile().getAbsolutePath().equals(c.getAfterRevision().getFile().getIOFile().getAbsolutePath()) || !file.isUnder(beforeRevision.getFile(), true) || !c.isIsReplaced()) continue;
                        ChangesCacheFile.debug("For " + file + "some of parents is replaced: " + beforeRevision.getFile());
                        return true;
                    }
                    indexOffset += 26L;
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            return false;
        }

        private IndexEntry getIndexEntryAtOffset(long indexOffset) throws IOException {
            IndexEntry e = this.myIndexEntryCache.get(indexOffset);
            if (e == null) {
                ChangesCacheFile.this.myIndexStream.seek(indexOffset);
                e = new IndexEntry();
                ChangesCacheFile.this.readIndexEntry(e);
                this.myIndexEntryCache.put(indexOffset, e);
            }
            return e;
        }

        private CommittedChangeList getChangeListAtOffset(long offset) throws IOException {
            CommittedChangeList changeList = this.myPreviousChangeListsCache.get(offset);
            if (changeList == null) {
                changeList = ChangesCacheFile.this.loadChangeListAt(offset);
                this.myPreviousChangeListsCache.put(offset, changeList);
            }
            return changeList;
        }

        private boolean isDeletedFile(Set<FilePath> deletedFiles, ContentRevision afterRevision, Set<FilePath> replacedFiles) {
            FilePath file = afterRevision.getFile();
            while (file != null) {
                if (deletedFiles.contains(file)) {
                    return true;
                }
                if ((file = file.getParentPath()) == null || !replacedFiles.contains(file)) continue;
                return true;
            }
            return false;
        }
    }

    private class BackIterator
    implements Iterator<ChangesBunch> {
        private final int bunchSize;
        private long myOffset;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BackIterator(int bunchSize) {
            this.bunchSize = bunchSize;
            try {
                try {
                    ChangesCacheFile.this.openStreams();
                    this.myOffset = ChangesCacheFile.this.myIndexStream.length() / 26L;
                }
                finally {
                    ChangesCacheFile.this.closeStreams();
                }
            }
            catch (IOException e) {
                this.myOffset = -1L;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myOffset > 0L;
        }

        @Override
        @Nullable
        public ChangesBunch next() {
            try {
                int size;
                if (this.myOffset < (long)this.bunchSize) {
                    size = (int)this.myOffset;
                    this.myOffset = 0L;
                } else {
                    this.myOffset -= (long)this.bunchSize;
                    size = this.bunchSize;
                }
                return new ChangesBunch(ChangesCacheFile.this.readChangesInterval(this.myOffset, size), true);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

