/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;

public class CacheSettingsPanel
implements Configurable {
    private JSpinner myCountSpinner;
    private JPanel myTopPanel;
    private JSpinner myRefreshSpinner;
    private JCheckBox myRefreshCheckbox;
    private JSpinner myDaysSpinner;
    private JLabel myCountLabel;
    private JLabel myDaysLabel;
    private CommittedChangesCache myCache;

    public CacheSettingsPanel() {
        this.$$$setupUI$$$();
        this.myRefreshCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CacheSettingsPanel.this.updateControls();
            }
        });
    }

    public void initPanel(Project project) {
        this.myCache = CommittedChangesCache.getInstance(project);
    }

    public void apply() throws ConfigurationException {
        CommittedChangesCache.State state = new CommittedChangesCache.State();
        state.setInitialCount(((SpinnerNumberModel)this.myCountSpinner.getModel()).getNumber().intValue());
        state.setInitialDays(((SpinnerNumberModel)this.myDaysSpinner.getModel()).getNumber().intValue());
        state.setRefreshInterval(((SpinnerNumberModel)this.myRefreshSpinner.getModel()).getNumber().intValue());
        state.setRefreshEnabled(this.myRefreshCheckbox.isSelected());
        this.myCache.loadState(state);
    }

    public boolean isModified() {
        CommittedChangesCache.State state = this.myCache.getState();
        if (state.getInitialCount() != ((SpinnerNumberModel)this.myCountSpinner.getModel()).getNumber().intValue()) {
            return true;
        }
        if (state.getInitialDays() != ((SpinnerNumberModel)this.myDaysSpinner.getModel()).getNumber().intValue()) {
            return true;
        }
        if (state.getRefreshInterval() != ((SpinnerNumberModel)this.myRefreshSpinner.getModel()).getNumber().intValue()) {
            return true;
        }
        return state.isRefreshEnabled() != this.myRefreshCheckbox.isSelected();
    }

    public void reset() {
        CommittedChangesCache.State state = this.myCache.getState();
        this.myCountSpinner.setModel(new SpinnerNumberModel(state.getInitialCount(), 1, 100000, 10));
        this.myDaysSpinner.setModel(new SpinnerNumberModel(state.getInitialDays(), 1, 720, 10));
        this.myRefreshSpinner.setModel(new SpinnerNumberModel(state.getRefreshInterval(), 1, 1440, 1));
        if (this.myCache.isMaxCountSupportedForProject()) {
            this.myDaysLabel.setVisible(false);
            this.myDaysSpinner.setVisible(false);
        } else {
            this.myCountLabel.setVisible(false);
            this.myCountSpinner.setVisible(false);
        }
        this.myRefreshCheckbox.setSelected(state.isRefreshEnabled());
        this.updateControls();
    }

    private void updateControls() {
        this.myRefreshSpinner.setEnabled(this.myRefreshCheckbox.isSelected());
    }

    public JComponent getPanel() {
        return this.myTopPanel;
    }

    @Nls
    public String getDisplayName() {
        return "Cache";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Cache";
    }

    public JComponent createComponent() {
        return this.getPanel();
    }

    public void disposeUIResources() {
    }

    public void setEnableCaching(boolean value) {
        this.myRefreshCheckbox.setSelected(value);
    }

    public void setEnabled(boolean value) {
        this.myRefreshCheckbox.setEnabled(value);
    }

    public boolean isCachingEnabled() {
        return this.myRefreshCheckbox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JSpinner jSpinner3;
        JLabel jLabel2;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCountLabel = jLabel2 = new JLabel();
        jLabel2.setText("Changelists to cache initially:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCountSpinner = jSpinner3 = new JSpinner();
        jPanel.add((Component)jSpinner3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(80, -1), null));
        this.myDaysSpinner = jSpinner2 = new JSpinner();
        jPanel.add((Component)jSpinner2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(80, -1), null));
        this.myRefreshSpinner = jSpinner = new JSpinner();
        jPanel.add((Component)jSpinner, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(80, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRefreshCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Refresh changes every");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("minutes");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDaysLabel = jLabel = new JLabel();
        jLabel.setText("Days of history to cache initially:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

