/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequest
implements ChangeRequestChain {
    private final List<DiffRequestPresentable> mySteps;
    private final boolean myShowFrame;
    private int myIndex;
    private final ShowDiffAction.DiffExtendUIFactory myActionsFactory;
    private final AnAction myPrevChangeAction;
    private final AnAction myNextChangeAction;
    private final Project myProject;

    public ChangeDiffRequest(Project project, List<DiffRequestPresentable> steps, ShowDiffAction.DiffExtendUIFactory actionsFactory, boolean showFrame) {
        this.myProject = project;
        this.mySteps = steps;
        this.myShowFrame = showFrame;
        this.myIndex = 0;
        this.myActionsFactory = actionsFactory;
        this.myPrevChangeAction = ActionManager.getInstance().getAction("Diff.PrevChange");
        this.myNextChangeAction = ActionManager.getInstance().getAction("Diff.NextChange");
    }

    private void onEveryMove(DiffRequest simpleRequest, boolean showFrame) {
        simpleRequest.passForDataContext(VcsDataKeys.DIFF_REQUEST_CHAIN, (Object)this);
        if (showFrame) {
            simpleRequest.addHint(DiffTool.HINT_SHOW_FRAME);
        } else {
            simpleRequest.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
        }
        if (this.mySteps.size() > 1) {
            simpleRequest.addHint(DiffTool.HINT_ALLOW_NO_DIFFERENCES);
        }
    }

    public boolean quickCheckHaveStuff() {
        if (this.mySteps.isEmpty()) {
            return false;
        }
        if (this.mySteps.size() == 1) {
            return this.mySteps.get(0).haveStuff();
        }
        return true;
    }

    @Nullable
    public DiffRequest init(int idx) {
        if (idx < 0 || idx > this.mySteps.size() - 1) {
            return null;
        }
        this.myIndex = idx - 1;
        return this.moveForward();
    }

    public boolean canMoveForward() {
        return this.myIndex < this.mySteps.size() - 1;
    }

    public boolean canMoveBack() {
        return this.myIndex > 0;
    }

    @Nullable
    public DiffRequest moveForward() {
        return this.moveImpl(new MoveDirection(){

            @Override
            public boolean canMove() {
                return ChangeDiffRequest.this.canMoveForward();
            }

            @Override
            public int direction() {
                return 1;
            }
        });
    }

    @Nullable
    private DiffRequest moveImpl(MoveDirection moveDirection) {
        while (moveDirection.canMove()) {
            int nextIdx = this.myIndex + moveDirection.direction();
            DiffRequestPresentable diffRequestPresentable = this.mySteps.get(nextIdx);
            DiffRequestPresentable.MyResult result = diffRequestPresentable.step();
            DiffPresentationReturnValue returnValue = result.getReturnValue();
            if (DiffPresentationReturnValue.quit.equals((Object)returnValue)) {
                return null;
            }
            if (DiffPresentationReturnValue.removeFromList.equals((Object)returnValue)) {
                this.mySteps.remove(nextIdx);
                continue;
            }
            DiffRequest request = result.getRequest();
            this.takeStuffFromFactory(request, diffRequestPresentable.createActions(this.myActionsFactory));
            this.myIndex = nextIdx;
            this.onEveryMove(request, this.myShowFrame);
            return request;
        }
        return null;
    }

    @Nullable
    public DiffRequest moveBack() {
        return this.moveImpl(new MoveDirection(){

            @Override
            public boolean canMove() {
                return ChangeDiffRequest.this.canMoveBack();
            }

            @Override
            public int direction() {
                return -1;
            }
        });
    }

    private void takeStuffFromFactory(DiffRequest request, final List<? extends AnAction> actions) {
        if (this.mySteps.size() > 1 || this.myActionsFactory != null) {
            request.setToolbarAddons(new DiffRequest.ToolbarAddons(){

                public void customize(DiffToolbar toolbar) {
                    if (ChangeDiffRequest.this.mySteps.size() > 1) {
                        toolbar.addSeparator();
                    }
                    toolbar.addAction(ChangeDiffRequest.this.myPrevChangeAction);
                    toolbar.addAction(ChangeDiffRequest.this.myNextChangeAction);
                    if (ChangeDiffRequest.this.myActionsFactory != null) {
                        toolbar.addSeparator();
                        for (AnAction action : actions) {
                            toolbar.addAction(action);
                        }
                    }
                }
            });
        }
        if (this.myActionsFactory != null) {
            request.setBottomComponentFactory((Factory)new NullableFactory<JComponent>(){

                public JComponent create() {
                    return ChangeDiffRequest.this.myActionsFactory.createBottomComponent();
                }
            });
        }
    }

    private static interface MoveDirection {
        public boolean canMove();

        public int direction();
    }
}

