/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class VcsGuess {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private final ExcludedFileIndex myExcludedFileIndex;

    VcsGuess(Project project) {
        this.myProject = project;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerImpl.getInstance((Project)this.myProject);
        this.myExcludedFileIndex = ExcludedFileIndex.getInstance((Project)this.myProject);
    }

    @Nullable
    public AbstractVcs getVcsForDirty(VirtualFile file) {
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        if (this.myExcludedFileIndex.isInContent(file) || this.isFileInBaseDir(file) || this.myVcsManager.hasExplicitMapping(file) || file.equals(this.myProject.getBaseDir())) {
            if (this.myExcludedFileIndex.isExcludedFile(file)) {
                return null;
            }
            return this.myVcsManager.getVcsFor(file);
        }
        return null;
    }

    @Nullable
    public AbstractVcs getVcsForDirty(final FilePath filePath) {
        if (filePath.isNonLocal()) {
            return null;
        }
        VirtualFile validParent = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return ChangesUtil.findValidParent((FilePath)filePath);
            }
        });
        if (validParent == null) {
            return null;
        }
        if (this.myExcludedFileIndex.isInContent(validParent) || this.isFileInBaseDir(filePath) || this.myVcsManager.hasExplicitMapping(validParent) || this.isInDirectoryBasedRoot(validParent)) {
            if (this.myExcludedFileIndex.isExcludedFile(validParent)) {
                return null;
            }
            return this.myVcsManager.getVcsFor(validParent);
        }
        return null;
    }

    private boolean isInDirectoryBasedRoot(VirtualFile file) {
        if (file == null) {
            return false;
        }
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme)) {
            VirtualFile baseDir = this.myProject.getBaseDir();
            if (baseDir == null) {
                return false;
            }
            VirtualFile ideaDir = baseDir.findChild(".idea");
            return ideaDir != null && ideaDir.isValid() && ideaDir.isDirectory() && VfsUtil.isAncestor((VirtualFile)ideaDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    private boolean isFileInBaseDir(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return !file.isDirectory() && parent != null && parent.equals(this.myProject.getBaseDir());
    }

    private boolean isFileInBaseDir(FilePath filePath) {
        VirtualFile parent = filePath.getVirtualFileParent();
        return !filePath.isDirectory() && parent != null && parent.equals(this.myProject.getBaseDir());
    }
}

