/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Scopes {
    private final Project myProject;
    private final VcsGuess myGuess;
    private boolean myEverythingDirty;
    private final Map<AbstractVcs, VcsDirtyScopeImpl> myScopes;

    public Scopes(Project project, VcsGuess guess) {
        this.myProject = project;
        this.myGuess = guess;
        this.myScopes = new HashMap<AbstractVcs, VcsDirtyScopeImpl>();
    }

    private void markEverythingDirty() {
        this.myScopes.clear();
        this.myEverythingDirty = true;
        DirtBuilder builder = new DirtBuilder(this.myGuess);
        DefaultVcsRootPolicy.getInstance(this.myProject).markDefaultRootsDirty(builder, this.myGuess);
        this.takeDirt(builder);
    }

    public void takeDirt(DirtBuilderReader dirt) {
        if (dirt.isEverythingDirty()) {
            this.markEverythingDirty();
            return;
        }
        Collection<FilePathUnderVcs> dirs = dirt.getDirsForVcs();
        for (FilePathUnderVcs dir : dirs) {
            this.getScope(dir.getVcs()).addDirtyDirRecursively(dir.getPath());
        }
        Collection<FilePathUnderVcs> files = dirt.getFilesForVcs();
        for (FilePathUnderVcs file : files) {
            this.getScope(file.getVcs()).addDirtyFile(file.getPath());
        }
    }

    public void addDirtyDirRecursively(@NotNull AbstractVcs vcs, @NotNull FilePath newcomer) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/Scopes.addDirtyDirRecursively must not be null");
        }
        if (newcomer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/Scopes.addDirtyDirRecursively must not be null");
        }
        this.getScope(vcs).addDirtyDirRecursively(newcomer);
    }

    public void addDirtyFile(@NotNull AbstractVcs vcs, @NotNull FilePath newcomer) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/Scopes.addDirtyFile must not be null");
        }
        if (newcomer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/Scopes.addDirtyFile must not be null");
        }
        this.getScope(vcs).addDirtyFile(newcomer);
    }

    @NotNull
    public VcsInvalidated retrieveAndClear() {
        ArrayList<VcsDirtyScopeImpl> scopesList = new ArrayList<VcsDirtyScopeImpl>(this.myScopes.values());
        VcsInvalidated result = new VcsInvalidated(scopesList, this.myEverythingDirty);
        this.myEverythingDirty = false;
        this.myScopes.clear();
        VcsInvalidated vcsInvalidated = result;
        if (vcsInvalidated == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/Scopes.retrieveAndClear must not return null");
        }
        return vcsInvalidated;
    }

    private VcsDirtyScopeImpl getScope(AbstractVcs vcs) {
        VcsDirtyScopeImpl scope = this.myScopes.get(vcs);
        if (scope == null) {
            scope = new VcsDirtyScopeImpl(vcs, this.myProject);
            this.myScopes.put(vcs, scope);
        }
        return scope;
    }
}

