/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ControlledCycle;
import com.intellij.openapi.vcs.changes.PlusMinus;
import com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache;
import com.intellij.openapi.vcs.changes.RemoteRevisionsStateCache;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RemoteRevisionsCache
implements PlusMinus<Pair<String, AbstractVcs>>,
VcsListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.RemoteRevisionsCache");
    public static Topic<Runnable> REMOTE_VERSION_CHANGED = new Topic("REMOTE_VERSION_CHANGED", Runnable.class);
    private final RemoteRevisionsNumbersCache myRemoteRevisionsNumbersCache;
    private final RemoteRevisionsStateCache myRemoteRevisionsStateCache;
    private final ProjectLevelVcsManager myVcsManager;
    private final RemoteStatusChangeNodeDecorator myChangeDecorator;
    private final Project myProject;
    private final Object myLock;
    private final Map<String, RemoteDifferenceStrategy> myKinds;
    private ControlledCycle myControlledCycle;

    public static RemoteRevisionsCache getInstance(Project project) {
        return (RemoteRevisionsCache)ServiceManager.getService((Project)project, RemoteRevisionsCache.class);
    }

    private RemoteRevisionsCache(Project project) {
        this.myProject = project;
        this.myLock = new Object();
        this.myRemoteRevisionsNumbersCache = new RemoteRevisionsNumbersCache(this.myProject);
        this.myRemoteRevisionsStateCache = new RemoteRevisionsStateCache(this.myProject);
        this.myChangeDecorator = new RemoteStatusChangeNodeDecorator(this);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcsManager.addVcsListener((VcsListener)this);
        this.myKinds = new HashMap<String, RemoteDifferenceStrategy>();
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                RemoteRevisionsCache.this.myVcsManager.removeVcsListener((VcsListener)RemoteRevisionsCache.this);
            }
        });
        this.updateKinds();
        this.myControlledCycle = new ControlledCycle(project, new ControlledCycle.MyCallback(){

            @Override
            public boolean call(AtomicSectionsAware atomicSectionsAware) {
                atomicSectionsAware.checkShouldExit();
                boolean shouldBeDone = VcsConfiguration.getInstance((Project)((RemoteRevisionsCache)RemoteRevisionsCache.this).myProject).CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND;
                if (shouldBeDone) {
                    boolean somethingChanged = RemoteRevisionsCache.this.myRemoteRevisionsNumbersCache.updateStep(atomicSectionsAware);
                    atomicSectionsAware.checkShouldExit();
                    if (somethingChanged |= RemoteRevisionsCache.this.myRemoteRevisionsStateCache.updateStep(atomicSectionsAware)) {
                        ((Runnable)RemoteRevisionsCache.this.myProject.getMessageBus().syncPublisher(REMOTE_VERSION_CHANGED)).run();
                    }
                }
                return shouldBeDone;
            }
        }, "Finishing \"changed on server\" update", 180000);
        if (!this.myProject.isDefault() && VcsConfiguration.getInstance((Project)this.myProject).CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND) {
            ((ProjectLevelVcsManagerImpl)this.myVcsManager).addInitializationRequest(VcsInitObject.REMOTE_REVISIONS_CACHE, new Runnable(){

                @Override
                public void run() {
                    RemoteRevisionsCache.this.myControlledCycle.start();
                }
            });
        }
    }

    public void startRefreshInBackground() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myControlledCycle.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKinds() {
        VcsRoot[] roots = this.myVcsManager.getAllVcsRoots();
        Object object = this.myLock;
        synchronized (object) {
            for (VcsRoot root : roots) {
                AbstractVcs vcs = root.vcs;
                if (this.myKinds.containsKey(vcs.getName())) continue;
                this.myKinds.put(vcs.getName(), vcs.getRemoteDifferenceStrategy());
            }
        }
    }

    public void directoryMappingChanged() {
        this.updateKinds();
        this.myRemoteRevisionsNumbersCache.directoryMappingChanged();
        this.myRemoteRevisionsStateCache.directoryMappingChanged();
    }

    @Override
    public void plus(Pair<String, AbstractVcs> pair) {
        AbstractVcs vcs = (AbstractVcs)pair.getSecond();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.plus(pair);
        } else {
            this.myRemoteRevisionsNumbersCache.plus(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(UpdatedFiles updatedFiles) {
        HashMap<String, RemoteDifferenceStrategy> strategyMap;
        Object object = this.myLock;
        synchronized (object) {
            strategyMap = new HashMap<String, RemoteDifferenceStrategy>(this.myKinds);
        }
        final LinkedList<String> newForTree = new LinkedList<String>();
        final LinkedList<String> newForUsual = new LinkedList<String>();
        UpdateFilesHelper.iterateAffectedFiles(updatedFiles, new Consumer<Pair<String, String>>(){

            public void consume(Pair<String, String> pair) {
                String vcsName = (String)pair.getSecond();
                RemoteDifferenceStrategy strategy = (RemoteDifferenceStrategy)strategyMap.get(vcsName);
                if (strategy == null) {
                    AbstractVcs vcs = RemoteRevisionsCache.this.myVcsManager.findVcsByName(vcsName);
                    if (vcs == null) {
                        return;
                    }
                    strategy = vcs.getRemoteDifferenceStrategy();
                }
                if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
                    newForTree.add(pair.getFirst());
                } else {
                    newForUsual.add(pair.getFirst());
                }
            }
        });
        this.myRemoteRevisionsStateCache.invalidate(newForTree);
        this.myRemoteRevisionsNumbersCache.invalidate(newForUsual);
    }

    @Override
    public void minus(Pair<String, AbstractVcs> pair) {
        AbstractVcs vcs = (AbstractVcs)pair.getSecond();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.minus(pair);
        } else {
            this.myRemoteRevisionsNumbersCache.minus(pair);
        }
    }

    public boolean isUpToDate(Change change) {
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject);
        if (vcs == null) {
            return true;
        }
        RemoteDifferenceStrategy strategy = vcs.getRemoteDifferenceStrategy();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
            return this.myRemoteRevisionsStateCache.isUpToDate(change);
        }
        return this.myRemoteRevisionsNumbersCache.isUpToDate(change);
    }

    public RemoteStatusChangeNodeDecorator getChangesNodeDecorator() {
        return this.myChangeDecorator;
    }
}

