/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeList");
    private final Project myProject;
    private Collection<Change> myChanges = new HashSet<Change>();
    private Collection<Change> myReadChangesCache = null;
    private String myId;
    @NotNull
    private String myName;
    private String myComment = "";
    private boolean myIsDefault = false;
    private boolean myIsReadOnly = false;
    private ChangeHashSet myChangesBeforeUpdate;

    public static LocalChangeListImpl createEmptyChangeListImpl(Project project, String name) {
        return new LocalChangeListImpl(project, name);
    }

    private LocalChangeListImpl(Project project, String name) {
        this.myProject = project;
        this.myName = name;
    }

    private LocalChangeListImpl(LocalChangeListImpl origin) {
        this.myId = origin.getId();
        this.myName = origin.myName;
        this.myProject = origin.myProject;
    }

    public synchronized Collection<Change> getChanges() {
        this.createReadChangesCache();
        return this.myReadChangesCache;
    }

    private void createReadChangesCache() {
        if (this.myReadChangesCache == null) {
            this.myReadChangesCache = Collections.unmodifiableCollection(new HashSet<Change>(this.myChanges));
        }
    }

    @NotNull
    public synchronized String getId() {
        if (this.myId == null) {
            this.myId = UUID.randomUUID().toString();
        }
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/LocalChangeListImpl.getId must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/LocalChangeListImpl.getName must not return null");
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/LocalChangeListImpl.setName must not be null");
        }
        if (!this.myName.equals(name)) {
            this.myName = name;
        }
    }

    public String getComment() {
        return this.myComment;
    }

    public void setComment(String comment) {
        if (!Comparing.equal((String)comment, (String)this.myComment)) {
            this.myComment = comment != null ? comment : "";
        }
    }

    void setNameImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/LocalChangeListImpl.setNameImpl must not be null");
        }
        this.myName = name;
    }

    void setCommentImpl(String comment) {
        this.myComment = comment;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    void setDefault(boolean isDefault) {
        this.myIsDefault = isDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myIsReadOnly = isReadOnly;
    }

    synchronized void addChange(Change change) {
        this.myReadChangesCache = null;
        this.myChanges.add(change);
    }

    synchronized Change removeChange(Change change) {
        for (Change localChange : this.myChanges) {
            if (!localChange.equals((Object)change)) continue;
            this.myChanges.remove(localChange);
            this.myReadChangesCache = null;
            return localChange;
        }
        return null;
    }

    synchronized Collection<Change> startProcessingChanges(Project project, @Nullable VcsDirtyScope scope) {
        this.createReadChangesCache();
        ArrayList<Change> result = new ArrayList<Change>();
        this.myChangesBeforeUpdate = new ChangeHashSet(this.myChanges);
        ExcludedFileIndex fileIndex = ExcludedFileIndex.getInstance((Project)project);
        Iterator i$ = this.myChangesBeforeUpdate.iterator();
        while (i$.hasNext()) {
            Change oldBoy = (Change)i$.next();
            ContentRevision before = oldBoy.getBeforeRevision();
            ContentRevision after = oldBoy.getAfterRevision();
            if (!(scope == null || before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile())) && !LocalChangeListImpl.isIgnoredChange(oldBoy, fileIndex)) continue;
            result.add(oldBoy);
            this.removeChange(oldBoy);
        }
        return result;
    }

    private static boolean isIgnoredChange(Change change, ExcludedFileIndex fileIndex) {
        boolean beforeRevIgnored = change.getBeforeRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getBeforeRevision(), fileIndex);
        boolean afterRevIgnored = change.getAfterRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getAfterRevision(), fileIndex);
        return beforeRevIgnored && afterRevIgnored;
    }

    private static boolean isIgnoredRevision(ContentRevision revision, ExcludedFileIndex fileIndex) {
        VirtualFile vFile = revision.getFile().getVirtualFile();
        return vFile != null && fileIndex.isExcludedFile(vFile);
    }

    synchronized boolean processChange(Change change) {
        LOG.debug("[process change] for '" + this.myName + "' isDefault: " + this.myIsDefault + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        if (this.myIsDefault) {
            LOG.debug("[process change] adding because default");
            this.addChange(change);
            return true;
        }
        Iterator i$ = this.myChangesBeforeUpdate.iterator();
        while (i$.hasNext()) {
            Change oldChange = (Change)i$.next();
            if (!Comparing.equal((Object)oldChange, (Object)change)) continue;
            LOG.debug("[process change] adding bacuae equal to old: " + ChangesUtil.getFilePath((Change)oldChange).getPath());
            this.addChange(change);
            return true;
        }
        LOG.debug("[process change] not found");
        return false;
    }

    synchronized boolean doneProcessingChanges(List<Change> removedChanges, List<Change> addedChanges) {
        boolean changesDetected = this.myChanges.size() != this.myChangesBeforeUpdate.size();
        for (Change newChange : this.myChanges) {
            Change oldChange = this.findOldChange(newChange);
            if (oldChange != null) continue;
            addedChanges.add(newChange);
        }
        changesDetected |= !addedChanges.isEmpty();
        ArrayList removed = new ArrayList(this.myChangesBeforeUpdate);
        removed.removeAll(this.myChanges);
        removedChanges.addAll(removed);
        changesDetected = changesDetected || !removedChanges.isEmpty();
        this.myReadChangesCache = null;
        return changesDetected;
    }

    @Nullable
    private Change findOldChange(Change newChange) {
        Change oldChange = this.myChangesBeforeUpdate.getEqualChange(newChange);
        if (oldChange != null && LocalChangeListImpl.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
            return oldChange;
        }
        return null;
    }

    private static boolean sameBeforeRevision(Change change1, Change change2) {
        ContentRevision b1 = change1.getBeforeRevision();
        ContentRevision b2 = change2.getBeforeRevision();
        if (b1 != null && b2 != null) {
            VcsRevisionNumber rn1 = b1.getRevisionNumber();
            VcsRevisionNumber rn2 = b2.getRevisionNumber();
            boolean isBinary1 = b1 instanceof BinaryContentRevision;
            boolean isBinary2 = b2 instanceof BinaryContentRevision;
            return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
        }
        return false;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list = (LocalChangeListImpl)((Object)o);
        if (this.myIsDefault != list.myIsDefault) {
            return false;
        }
        if (!this.myName.equals(list.myName)) {
            return false;
        }
        return this.myIsReadOnly == list.myIsReadOnly;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName.trim();
    }

    public synchronized LocalChangeList copy() {
        LocalChangeListImpl copy = new LocalChangeListImpl(this);
        copy.myComment = this.myComment;
        copy.myIsDefault = this.myIsDefault;
        copy.myIsReadOnly = this.myIsReadOnly;
        if (this.myChanges != null) {
            copy.myChanges = new HashSet<Change>(this.myChanges);
        }
        if (this.myChangesBeforeUpdate != null) {
            copy.myChangesBeforeUpdate = new ChangeHashSet((Collection<? extends Change>)((Object)this.myChangesBeforeUpdate));
        }
        if (this.myReadChangesCache != null) {
            copy.myReadChangesCache = new HashSet<Change>(this.myReadChangesCache);
        }
        return copy;
    }

    @Nullable
    public ChangeListEditHandler getEditHandler() {
        return null;
    }

    public void setId(String id) {
        this.myId = id;
    }

    private static class ChangeHashSet
    extends THashSet<Change> {
        public ChangeHashSet(Collection<? extends Change> changes) {
            super(changes);
        }

        @Nullable
        Change getEqualChange(Change other) {
            int aIndex = this.index(other);
            if (aIndex >= 0) {
                return (Change)this._set[aIndex];
            }
            return null;
        }
    }
}

