/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(VcsContext dataContext) {
        FilePath[] roots = this.getRoots(dataContext);
        if (roots == null || roots.length == 0) {
            return this.getCheckinActionName(dataContext);
        }
        FilePath first = roots[0];
        if (roots.length == 1) {
            if (first.isDirectory()) {
                return VcsBundle.message((String)"action.name.checkin.directory", (Object[])new Object[]{this.getCheckinActionName(dataContext)});
            }
            return VcsBundle.message((String)"action.name.checkin.file", (Object[])new Object[]{this.getCheckinActionName(dataContext)});
        }
        if (first.isDirectory()) {
            return VcsBundle.message((String)"action.name.checkin.directories", (Object[])new Object[]{this.getCheckinActionName(dataContext)});
        }
        return VcsBundle.message((String)"action.name.checkin.files", (Object[])new Object[]{this.getCheckinActionName(dataContext)});
    }

    @Override
    protected LocalChangeList getInitiallySelectedChangeList(VcsContext context, Project project) {
        FilePath[] roots;
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (FilePath root : roots = this.getRoots(context)) {
            VirtualFile file = root.getVirtualFile();
            if (file == null) continue;
            final Ref change = new Ref();
            if (!file.isDirectory()) {
                change.set((Object)changeListManager.getChange(file));
            } else {
                final ExcludedFileIndex index = ExcludedFileIndex.getInstance((Project)project);
                VirtualFileFilter filter = new VirtualFileFilter(){

                    public boolean accept(VirtualFile file) {
                        return !index.isExcludedFile(file);
                    }
                };
                FileIndexImplUtil.iterateRecursively((VirtualFile)file, (VirtualFileFilter)filter, (ContentIterator)new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        Change c = changeListManager.getChange(fileOrDir);
                        if (c != null) {
                            change.set((Object)c);
                            return false;
                        }
                        return true;
                    }
                });
            }
            if (change.isNull()) continue;
            return changeListManager.getChangeList((Change)change.get());
        }
        return changeListManager.getDefaultChangeList();
    }

    private String getCheckinActionName(VcsContext dataContext) {
        Project project = dataContext.getProject();
        if (project == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        AbstractVcs vcs = CommonCheckinFilesAction.getCommonVcsFor(this.getRoots(dataContext), project);
        if (vcs == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        return checkinEnvironment.getCheckinOperationName();
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        return dataContext.getSelectedFilePaths().length > 0;
    }

    @Override
    protected FilePath[] getRoots(VcsContext context) {
        return context.getSelectedFilePaths();
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return true;
    }
}

