/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathImpl
implements FilePath {
    private VirtualFile myVirtualFile;
    private VirtualFile myVirtualParent;
    private final String myName;
    @NotNull
    private final File myFile;
    private boolean myIsDirectory;
    private boolean myNonLocal;
    private static Constructor<File> ourFileStringConstructor;
    private static boolean ourFileStringConstructorInitialized;

    private FilePathImpl(VirtualFile virtualParent, String name, boolean isDirectory, VirtualFile child, boolean forDeleted) {
        this.myVirtualParent = virtualParent;
        this.myName = name;
        this.myIsDirectory = isDirectory;
        this.myFile = this.myVirtualParent == null ? new File(this.myName) : new File(new File(this.myVirtualParent.getPath()), this.myName);
        if (!forDeleted) {
            if (child == null) {
                this.refresh();
            } else {
                this.myVirtualFile = child;
            }
        }
    }

    public FilePathImpl(VirtualFile virtualParent, String name, boolean isDirectory) {
        this(virtualParent, name, isDirectory, null, false);
    }

    private FilePathImpl(VirtualFile virtualParent, String name, boolean isDirectory, boolean forDeleted) {
        this(virtualParent, name, isDirectory, null, forDeleted);
    }

    public FilePathImpl(File file, boolean isDirectory) {
        this.myFile = file;
        this.myName = file.getName();
        this.myIsDirectory = isDirectory;
    }

    public FilePathImpl(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/FilePathImpl.<init> must not be null");
        }
        this(virtualFile.getParent(), virtualFile.getName(), virtualFile.isDirectory(), virtualFile, false);
    }

    public int hashCode() {
        return StringUtil.stringHashCodeInsensitive((CharSequence)this.myFile.getPath());
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilePath)) {
            return false;
        }
        return this.myFile.equals(((FilePath)o).getIOFile());
    }

    public void refresh() {
        if (!this.myNonLocal) {
            this.myVirtualFile = this.myVirtualParent == null ? LocalFileSystem.getInstance().findFileByIoFile(this.myFile) : this.myVirtualParent.findChild(this.myName);
        }
    }

    public String getPath() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile != null && virtualFile.isValid()) {
            return virtualFile.getPath();
        }
        return this.myFile.getPath();
    }

    public boolean isDirectory() {
        if (this.myVirtualFile == null) {
            return this.myIsDirectory;
        }
        return this.myVirtualFile.isDirectory();
    }

    public boolean isUnder(FilePath parent, boolean strict) {
        if (this.myVirtualFile != null && parent.getVirtualFile() != null) {
            return VfsUtil.isAncestor((VirtualFile)parent.getVirtualFile(), (VirtualFile)this.myVirtualFile, (boolean)strict);
        }
        try {
            return FileUtil.isAncestor((File)parent.getIOFile(), (File)this.getIOFile(), (boolean)strict);
        }
        catch (IOException e) {
            return false;
        }
    }

    public FilePath getParentPath() {
        if (this.myVirtualParent != null && this.myVirtualParent.isValid()) {
            return new FilePathImpl(this.myVirtualParent);
        }
        String path = this.myFile.getPath();
        int pos = path.lastIndexOf(File.separatorChar);
        if (pos < 0 || pos == path.indexOf(File.separatorChar)) {
            return null;
        }
        return new FilePathImpl(new File(path.substring(0, pos)), true);
    }

    public VirtualFile getVirtualFile() {
        if (this.myVirtualFile != null && !this.myVirtualFile.isValid()) {
            this.myVirtualFile = null;
        }
        return this.myVirtualFile;
    }

    public VirtualFile getVirtualFileParent() {
        if (this.myVirtualParent != null && !this.myVirtualParent.isValid()) {
            this.myVirtualParent = null;
        }
        return this.myVirtualParent;
    }

    @NotNull
    public File getIOFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/FilePathImpl.getIOFile must not return null");
        }
        return file;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableUrl() {
        if (this.myVirtualFile == null) {
            return this.myFile.getAbsolutePath();
        }
        return this.myVirtualFile.getPresentableUrl();
    }

    @Nullable
    public Document getDocument() {
        if (this.myVirtualFile == null || this.myVirtualFile.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
    }

    public Charset getCharset() {
        return this.getCharset(null);
    }

    public Charset getCharset(Project project) {
        EncodingProjectManager e;
        Charset rc;
        VirtualFile existing;
        VirtualFile virtualFile = existing = this.myVirtualFile != null && this.myVirtualFile.isValid() ? this.myVirtualFile : null;
        if (existing == null) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (File f = this.myFile; !(f == null || (existing = lfs.findFileByIoFile(f)) != null && existing.isValid()); f = f.getParentFile()) {
            }
        }
        if (existing != null && (rc = existing.getCharset()) != null) {
            return rc;
        }
        EncodingProjectManager encodingProjectManager = e = project != null ? EncodingProjectManager.getInstance((Project)project) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return e.getDefaultCharset();
    }

    public FileType getFileType() {
        return this.myVirtualFile != null ? this.myVirtualFile.getFileType() : FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName());
    }

    public static FilePathImpl create(File selectedFile) {
        return FilePathImpl.create(selectedFile, false);
    }

    public static FilePathImpl create(File selectedFile, boolean isDirectory) {
        if (selectedFile == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = lfs.findFileByIoFile(selectedFile);
        if (virtualFile != null) {
            return new FilePathImpl(virtualFile);
        }
        return FilePathImpl.createForDeletedFile(selectedFile, isDirectory);
    }

    public static FilePathImpl createForDeletedFile(File selectedFile, boolean isDirectory) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parentFile = selectedFile.getParentFile();
        if (parentFile == null) {
            return new FilePathImpl(selectedFile, isDirectory);
        }
        VirtualFile virtualFileParent = lfs.findFileByIoFile(parentFile);
        if (virtualFileParent != null) {
            return new FilePathImpl(virtualFileParent, selectedFile.getName(), isDirectory, true);
        }
        return new FilePathImpl(selectedFile, isDirectory);
    }

    public static FilePath createOn(String s) {
        File ioFile = new File(s);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.findFileByIoFile(ioFile);
        if (virtualFile != null) {
            return new FilePathImpl(virtualFile);
        }
        VirtualFile virtualFileParent = localFileSystem.findFileByIoFile(ioFile.getParentFile());
        if (virtualFileParent != null) {
            return new FilePathImpl(virtualFileParent, ioFile.getName(), false);
        }
        return null;
    }

    @NotNull
    public static FilePath createNonLocal(String path, boolean directory) {
        path = path.replace('/', File.separatorChar);
        if (!ourFileStringConstructorInitialized) {
            ourFileStringConstructorInitialized = true;
            try {
                ourFileStringConstructor = File.class.getDeclaredConstructor(String.class, Integer.TYPE);
                ourFileStringConstructor.setAccessible(true);
            }
            catch (Exception ex) {
                ourFileStringConstructor = null;
            }
        }
        File file = null;
        try {
            if (ourFileStringConstructor != null) {
                file = ourFileStringConstructor.newInstance(path, 1);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (file == null) {
            file = new File(path);
        }
        FilePathImpl result = new FilePathImpl(file, directory);
        result.myNonLocal = true;
        FilePathImpl filePathImpl = result;
        if (filePathImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/FilePathImpl.createNonLocal must not return null");
        }
        return filePathImpl;
    }

    @NonNls
    public String toString() {
        return "FilePath[" + this.myFile + "]";
    }

    public boolean isNonLocal() {
        return this.myNonLocal;
    }
}

