/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class BuildInfo
implements Comparable<BuildInfo> {
    private final BuildNumber myNumber;
    private final String myVersion;
    private final String myMessage;
    private final List<PatchInfo> myPatches;

    public BuildInfo(Element node) {
        this.myNumber = BuildNumber.fromString((String)node.getAttributeValue("number"));
        this.myVersion = node.getAttributeValue("version");
        this.myPatches = new ArrayList<PatchInfo>();
        for (Object patchNode : node.getChildren("patch")) {
            this.myPatches.add(new PatchInfo((Element)patchNode));
        }
        Element messageTag = node.getChild("message");
        this.myMessage = messageTag != null ? messageTag.getValue() : "";
    }

    @Override
    public int compareTo(BuildInfo o) {
        return this.myNumber.compareTo(o.myNumber);
    }

    public BuildNumber getNumber() {
        return this.myNumber;
    }

    public String getVersion() {
        return this.myVersion != null ? this.myVersion : "";
    }

    public String getMessage() {
        return this.myMessage;
    }

    @Nullable
    public PatchInfo findPatchForCurrentBuild() {
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        for (PatchInfo each : this.myPatches) {
            if (!each.getFromBuild().asStringWithoutProductCode().equals(currentBuild.asStringWithoutProductCode())) continue;
            return each;
        }
        return null;
    }
}

